/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues;

import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import java.util.Collection;
import java.util.Map;

public interface UsageTrackedQueue {
    public void queueTask(QueuableTask var1) throws TaskQueueException;

    public QueuableTask nextTaskToLaunch() throws TaskQueueException;

    public void assignTask(QueuableTask var1) throws TaskQueueException;

    public boolean launchTask(QueuableTask var1) throws TaskQueueException;

    public QueuableTask removeTask(String var1, QAttributes var2) throws TaskQueueException;

    public double getDominantUsageShare(ResUsage var1);

    public void reset();

    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() throws TaskQueueException;

    public static class ResUsage {
        private double cpus = 0.0;
        private double memory = 0.0;
        private double networkMbps = 0.0;
        private double disk = 0.0;

        public void addUsage(QueuableTask task) {
            this.cpus += task.getCPUs();
            this.memory += task.getMemory();
            this.networkMbps += task.getNetworkMbps();
            this.disk += task.getDisk();
        }

        public void remUsage(QueuableTask task) {
            this.cpus -= task.getCPUs();
            this.memory -= task.getMemory();
            this.networkMbps -= task.getNetworkMbps();
            this.disk -= task.getDisk();
        }

        public double getCpus() {
            return this.cpus;
        }

        public double getMemory() {
            return this.memory;
        }

        public double getNetworkMbps() {
            return this.networkMbps;
        }

        public double getDisk() {
            return this.disk;
        }

        public double getDominantUsageShareFrom(ResUsage totals) {
            double tmp;
            double max = totals.cpus == 0.0 ? this.cpus : this.cpus / totals.cpus;
            double d = tmp = totals.memory == 0.0 ? this.memory : this.memory / totals.memory;
            if (tmp > max) {
                max = tmp;
            }
            double d2 = tmp = totals.networkMbps == 0.0 ? this.networkMbps : this.networkMbps / totals.networkMbps;
            if (tmp > max) {
                max = tmp;
            }
            double d3 = tmp = totals.disk == 0.0 ? this.disk : this.disk / totals.disk;
            if (tmp > max) {
                max = tmp;
            }
            return max;
        }
    }
}

