/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.ActiveVmGroups;
import com.netflix.fenzo.AssignableVMs;
import com.netflix.fenzo.AutoScaleAction;
import com.netflix.fenzo.AutoScaleRule;
import com.netflix.fenzo.AutoScaleRules;
import com.netflix.fenzo.AutoScalerInput;
import com.netflix.fenzo.ScaleDownAction;
import com.netflix.fenzo.ScaleUpAction;
import com.netflix.fenzo.ShortfallEvaluator;
import com.netflix.fenzo.TaskScheduler;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoScaler {
    private static final Logger logger = LoggerFactory.getLogger(AutoScaler.class);
    private volatile Action1<AutoScaleAction> callback = null;
    private final String mapHostnameAttributeName;
    private final String scaleDownBalancedByAttributeName;
    private ShortfallEvaluator shortfallEvaluator;
    private final ActiveVmGroups activeVmGroups;
    private final AutoScaleRules autoScaleRules;
    private final boolean disableShortfallEvaluation;
    private final String attributeName;
    private final AssignableVMs assignableVMs;
    private long delayScaleUpBySecs = 0L;
    private long delayScaleDownBySecs = 0L;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    final ConcurrentMap<String, ScalingActivity> scalingActivityMap = new ConcurrentHashMap<String, ScalingActivity>();

    AutoScaler(String attributeName, String mapHostnameAttributeName, String scaleDownBalancedByAttributeName, List<AutoScaleRule> autoScaleRules, AssignableVMs assignableVMs, TaskScheduler phantomTaskScheduler, boolean disableShortfallEvaluation, ActiveVmGroups activeVmGroups) {
        this.mapHostnameAttributeName = mapHostnameAttributeName;
        this.scaleDownBalancedByAttributeName = scaleDownBalancedByAttributeName;
        this.shortfallEvaluator = new ShortfallEvaluator(phantomTaskScheduler);
        this.attributeName = attributeName;
        this.autoScaleRules = new AutoScaleRules(autoScaleRules);
        this.assignableVMs = assignableVMs;
        this.disableShortfallEvaluation = disableShortfallEvaluation;
        this.activeVmGroups = activeVmGroups;
    }

    Collection<AutoScaleRule> getRules() {
        return Collections.unmodifiableCollection(this.autoScaleRules.getRules());
    }

    void replaceRule(AutoScaleRule rule) {
        if (rule == null) {
            throw new NullPointerException("Can't add null rule");
        }
        this.autoScaleRules.replaceRule(rule);
    }

    void removeRule(String ruleName) {
        if (ruleName != null) {
            this.autoScaleRules.remRule(ruleName);
        }
    }

    void setDelayScaleUpBySecs(long secs) {
        this.delayScaleUpBySecs = secs;
    }

    void setDelayScaleDownBySecs(long secs) {
        this.delayScaleDownBySecs = secs;
    }

    void scheduleAutoscale(final AutoScalerInput autoScalerInput) {
        if (this.isShutdown.get()) {
            return;
        }
        try {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    if (AutoScaler.this.isShutdown.get()) {
                        return;
                    }
                    AutoScaler.this.autoScaleRules.prepare();
                    Map hostAttributeGroupMap = AutoScaler.this.setupHostAttributeGroupMap(AutoScaler.this.autoScaleRules, AutoScaler.this.scalingActivityMap);
                    if (!AutoScaler.this.disableShortfallEvaluation) {
                        Map<String, Integer> shortfall = AutoScaler.this.shortfallEvaluator.getShortfall(hostAttributeGroupMap.keySet(), autoScalerInput.getFailures());
                        for (Map.Entry<String, Integer> entry : shortfall.entrySet()) {
                            ((HostAttributeGroup)hostAttributeGroupMap.get((Object)entry.getKey())).shortFall = entry.getValue() == null ? 0 : entry.getValue();
                        }
                    }
                    AutoScaler.this.populateIdleResources(autoScalerInput.getIdleResourcesList(), hostAttributeGroupMap, AutoScaler.this.attributeName);
                    for (HostAttributeGroup hostAttributeGroup : hostAttributeGroupMap.values()) {
                        AutoScaler.this.processScalingNeeds(hostAttributeGroup, AutoScaler.this.scalingActivityMap, AutoScaler.this.assignableVMs);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger.warn("Autoscaler execution request rejected: " + e.getMessage());
        }
    }

    private boolean shouldScaleNow(boolean scaleUp, long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return scaleUp ? now > Math.max(this.activeVmGroups.getLastSetAt(), prevScalingActivity.scaleUpAt) + rule.getCoolDownSecs() * 1000L : now > Math.max(this.activeVmGroups.getLastSetAt(), Math.max(prevScalingActivity.scaleDownAt, prevScalingActivity.scaleUpAt)) + rule.getCoolDownSecs() * 1000L;
    }

    private boolean shouldScaleUp(long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return this.shouldScaleNow(true, now, prevScalingActivity, rule);
    }

    private boolean shouldScaleDown(long now, ScalingActivity prevScalingActivity, AutoScaleRule rule) {
        return this.shouldScaleNow(false, now, prevScalingActivity, rule);
    }

    private void processScalingNeeds(HostAttributeGroup hostAttributeGroup, ConcurrentMap<String, ScalingActivity> scalingActivityMap, AssignableVMs assignableVMs) {
        int excess;
        AutoScaleRule rule = hostAttributeGroup.rule;
        long now = System.currentTimeMillis();
        ScalingActivity prevScalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
        int n = excess = hostAttributeGroup.shortFall > 0 ? 0 : hostAttributeGroup.idleHosts.size() - rule.getMaxIdleHostsToKeep();
        if (excess > 0 && this.shouldScaleDown(now, prevScalingActivity, rule)) {
            ScalingActivity scalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
            long lastReqstAge = (now - scalingActivity.scaleDownRequestedAt) / 1000L;
            if (this.delayScaleDownBySecs > 0L && lastReqstAge > 2L * this.delayScaleDownBySecs) {
                scalingActivity.scaleDownRequestedAt = now;
            } else if (this.delayScaleDownBySecs == 0L || lastReqstAge > this.delayScaleDownBySecs) {
                scalingActivity.scaleDownRequestedAt = 0L;
                scalingActivity.scaleDownAt = now;
                scalingActivity.shortfall = hostAttributeGroup.shortFall;
                Map<String, String> hostsToTerminate = this.getHostsToTerminate(hostAttributeGroup.idleHosts, excess);
                scalingActivity.scaledNumInstances = hostsToTerminate.size();
                scalingActivity.type = AutoScaleAction.Type.Down;
                StringBuilder sBuilder = new StringBuilder();
                for (String host : hostsToTerminate.keySet()) {
                    sBuilder.append(host).append(", ");
                    assignableVMs.disableUntil(host, now + rule.getCoolDownSecs() * 1000L);
                }
                logger.info("Scaling down " + rule.getRuleName() + " by " + excess + " hosts (" + sBuilder.toString() + ")");
                this.callback.call(new ScaleDownAction(rule.getRuleName(), hostsToTerminate.values()));
            }
        } else if ((hostAttributeGroup.shortFall > 0 || excess <= 0 && this.shouldScaleUp(now, prevScalingActivity, rule)) && (hostAttributeGroup.shortFall > 0 || rule.getMinIdleHostsToKeep() > hostAttributeGroup.idleHosts.size())) {
            ScalingActivity scalingActivity = (ScalingActivity)scalingActivityMap.get(rule.getRuleName());
            long lastReqstAge = (now - scalingActivity.scaleUpRequestedAt) / 1000L;
            if (this.delayScaleUpBySecs > 0L && lastReqstAge > 2L * this.delayScaleUpBySecs) {
                scalingActivity.scaleUpRequestedAt = now;
            } else if (this.delayScaleUpBySecs == 0L || lastReqstAge > this.delayScaleUpBySecs) {
                scalingActivity.scaleUpRequestedAt = 0L;
                int shortage = excess <= 0 && this.shouldScaleUp(now, prevScalingActivity, rule) ? rule.getMaxIdleHostsToKeep() - hostAttributeGroup.idleHosts.size() : 0;
                shortage = Math.max(shortage, hostAttributeGroup.shortFall);
                scalingActivity.scaleUpAt = now;
                scalingActivity.shortfall = hostAttributeGroup.shortFall;
                scalingActivity.scaledNumInstances = shortage;
                scalingActivity.type = AutoScaleAction.Type.Up;
                logger.info("Scaling up " + rule.getRuleName() + " by " + shortage + " hosts");
                this.callback.call(new ScaleUpAction(rule.getRuleName(), this.getEffectiveShortage(shortage, scalingActivity.shortfall)));
            }
        }
    }

    private int getEffectiveShortage(int shortage, int shortfall) {
        return Math.max(shortage, shortfall);
    }

    private void populateIdleResources(List<VirtualMachineLease> idleResources, Map<String, HostAttributeGroup> leasesMap, String attributeName) {
        for (VirtualMachineLease l : idleResources) {
            String attrValue;
            if (l.getAttributeMap() == null || l.getAttributeMap().get(attributeName) == null || !l.getAttributeMap().get(attributeName).getText().hasValue() || !leasesMap.containsKey(attrValue = l.getAttributeMap().get(attributeName).getText().getValue()) || leasesMap.get((Object)attrValue).rule.idleMachineTooSmall(l)) continue;
            leasesMap.get((Object)attrValue).idleHosts.add(l);
        }
    }

    private Map<String, HostAttributeGroup> setupHostAttributeGroupMap(AutoScaleRules autoScaleRules, ConcurrentMap<String, ScalingActivity> lastScalingAt) {
        HashMap<String, HostAttributeGroup> leasesMap = new HashMap<String, HostAttributeGroup>();
        for (AutoScaleRule rule : autoScaleRules.getRules()) {
            leasesMap.put(rule.getRuleName(), new HostAttributeGroup(rule.getRuleName(), rule));
            long initialCoolDown = this.getInitialCoolDown(rule.getCoolDownSecs());
            lastScalingAt.putIfAbsent(rule.getRuleName(), new ScalingActivity(initialCoolDown, initialCoolDown, 0, 0, null));
        }
        return leasesMap;
    }

    private long getInitialCoolDown(long coolDownSecs) {
        long initialCoolDownInPastSecs = 120L;
        initialCoolDownInPastSecs = Math.min(coolDownSecs, initialCoolDownInPastSecs);
        return System.currentTimeMillis() - coolDownSecs * 1000L + initialCoolDownInPastSecs * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getHostsToTerminate(List<VirtualMachineLease> hosts, int excess) {
        void var7_10;
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap hostsMap = new HashMap();
        String defaultAttributeName = "default";
        for (VirtualMachineLease virtualMachineLease : hosts) {
            String val;
            Protos.Attribute attribute = virtualMachineLease.getAttributeMap().get(this.scaleDownBalancedByAttributeName);
            String string = val = attribute != null && attribute.hasText() ? attribute.getText().getValue() : "default";
            if (hostsMap.get(val) == null) {
                hostsMap.put(val, new ArrayList());
            }
            ((List)hostsMap.get(val)).add(virtualMachineLease);
        }
        ArrayList<List> lists = new ArrayList<List>();
        for (List l : hostsMap.values()) {
            lists.add(l);
        }
        boolean bl = false;
        while (var7_10 < excess) {
            List takeFrom = null;
            int max = 0;
            for (List l : lists) {
                if (l.size() <= max) continue;
                max = l.size();
                takeFrom = l;
            }
            VirtualMachineLease removed = (VirtualMachineLease)takeFrom.remove(0);
            result.put(removed.hostname(), this.getMappedHostname(removed));
            ++var7_10;
        }
        return result;
    }

    private String getMappedHostname(VirtualMachineLease lease) {
        if (this.mapHostnameAttributeName == null || this.mapHostnameAttributeName.isEmpty()) {
            return lease.hostname();
        }
        Protos.Attribute attribute = lease.getAttributeMap().get(this.mapHostnameAttributeName);
        if (attribute == null) {
            logger.error("Didn't find attribute " + this.mapHostnameAttributeName + " for host " + lease.hostname());
            return lease.hostname();
        }
        return attribute.getText().getValue();
    }

    public void setCallback(Action1<AutoScaleAction> callback) {
        this.callback = callback;
    }

    void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.executor.shutdown();
        }
    }

    private static class ScalingActivity {
        private long scaleUpAt;
        private long scaleUpRequestedAt;
        private long scaleDownAt;
        private long scaleDownRequestedAt;
        private int shortfall;
        private int scaledNumInstances;
        private AutoScaleAction.Type type;

        private ScalingActivity(long scaleUpAt, long scaleDownAt, int shortfall, int scaledNumInstances, AutoScaleAction.Type type) {
            this.scaleUpAt = scaleUpAt;
            this.scaleUpRequestedAt = 0L;
            this.scaleDownAt = scaleDownAt;
            this.scaleDownRequestedAt = 0L;
            this.shortfall = shortfall;
            this.scaledNumInstances = scaledNumInstances;
            this.type = type;
        }
    }

    private static class HostAttributeGroup {
        String name;
        List<VirtualMachineLease> idleHosts;
        int shortFall;
        AutoScaleRule rule;

        private HostAttributeGroup(String name, AutoScaleRule rule) {
            this.name = name;
            this.rule = rule;
            this.idleHosts = new ArrayList<VirtualMachineLease>();
            this.shortFall = 0;
        }
    }
}

