/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.config.ConfigurationNode;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class RescheduleListenerManager
extends AbstractListenerManager {
    private final ConfigurationNode configNode;
    private final String jobName;

    public RescheduleListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configNode = new ConfigurationNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new CronSettingAndJobEventChangedJobListener());
    }

    class CronSettingAndJobEventChangedJobListener
    extends AbstractJobListener {
        CronSettingAndJobEventChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (RescheduleListenerManager.this.configNode.isConfigPath(path) && CuratorCacheListener.Type.NODE_CHANGED == eventType && !JobRegistry.getInstance().isShutdown(RescheduleListenerManager.this.jobName)) {
                JobConfiguration jobConfiguration = ((JobConfigurationPOJO)YamlEngine.unmarshal((String)data, JobConfigurationPOJO.class)).toJobConfiguration();
                if (StringUtils.isEmpty((CharSequence)jobConfiguration.getCron())) {
                    JobRegistry.getInstance().getJobScheduleController(RescheduleListenerManager.this.jobName).rescheduleJob();
                } else {
                    JobRegistry.getInstance().getJobScheduleController(RescheduleListenerManager.this.jobName).rescheduleJob(jobConfiguration.getCron());
                }
            }
        }
    }
}

