/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.queues.tiered.QueueBucket;
import com.netflix.fenzo.queues.tiered.SortedBuckets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

class Tier
implements UsageTrackedQueue {
    private final int tierNumber;
    private final UsageTrackedQueue.ResUsage totals = new UsageTrackedQueue.ResUsage();
    private final SortedBuckets sortedBuckets;

    Tier(int tierNumber) {
        this.tierNumber = tierNumber;
        this.sortedBuckets = new SortedBuckets(this.totals);
    }

    private QueueBucket getOrCreateBucket(QueuableTask t) {
        if (t == null) {
            throw new NullPointerException();
        }
        String bucketName = t.getQAttributes().getBucketName();
        QueueBucket bucket = this.sortedBuckets.get(bucketName);
        if (bucket == null) {
            bucket = new QueueBucket(this.tierNumber, bucketName);
            this.sortedBuckets.add(bucket);
        }
        return bucket;
    }

    @Override
    public void queueTask(QueuableTask t) throws TaskQueueException {
        this.getOrCreateBucket(t).queueTask(t);
    }

    @Override
    public QueuableTask nextTaskToLaunch() throws TaskQueueException {
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            QueuableTask task = bucket.nextTaskToLaunch();
            if (task == null) continue;
            return task;
        }
        return null;
    }

    @Override
    public void assignTask(QueuableTask t) throws TaskQueueException {
        QueueBucket bucket = this.sortedBuckets.remove(t.getQAttributes().getBucketName());
        if (bucket == null) {
            throw new TaskQueueException("Invalid to not find bucket to assign task id=" + t.getId());
        }
        try {
            bucket.assignTask(t);
            this.totals.addUsage(t);
        }
        finally {
            this.sortedBuckets.add(bucket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean launchTask(QueuableTask t) throws TaskQueueException {
        String bucketName = t.getQAttributes().getBucketName();
        QueueBucket bucket = this.sortedBuckets.remove(bucketName);
        if (bucket == null) {
            bucket = new QueueBucket(this.tierNumber, bucketName);
        }
        try {
            if (bucket.launchTask(t)) {
                this.totals.addUsage(t);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.sortedBuckets.add(bucket);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueuableTask removeTask(String id, QAttributes qAttributes) throws TaskQueueException {
        QueuableTask removed;
        QueueBucket bucket = this.sortedBuckets.remove(qAttributes.getBucketName());
        if (bucket == null) {
            return null;
        }
        try {
            removed = bucket.removeTask(id, qAttributes);
            if (removed != null) {
                this.totals.remUsage(removed);
            }
        }
        finally {
            if (bucket.size() > 0) {
                this.sortedBuckets.add(bucket);
            }
        }
        return removed;
    }

    @Override
    public double getDominantUsageShare(UsageTrackedQueue.ResUsage parentUsage) {
        return 0.0;
    }

    @Override
    public void reset() {
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            bucket.reset();
        }
    }

    @Override
    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() throws TaskQueueException {
        HashMap<TaskQueue.TaskState, Collection<QueuableTask>> result = new HashMap<TaskQueue.TaskState, Collection<QueuableTask>>();
        for (QueueBucket bucket : this.sortedBuckets.getSortedList()) {
            Map<TaskQueue.TaskState, Collection<QueuableTask>> allTasks = bucket.getAllTasks();
            if (allTasks.isEmpty()) continue;
            for (TaskQueue.TaskState s : TaskQueue.TaskState.values()) {
                Collection<QueuableTask> q = allTasks.get((Object)s);
                if (q == null || q.isEmpty()) continue;
                LinkedList<QueuableTask> resQ = (LinkedList<QueuableTask>)result.get((Object)s);
                if (resQ == null) {
                    resQ = new LinkedList<QueuableTask>();
                    result.put(s, resQ);
                }
                resQ.addAll(q);
            }
        }
        return result;
    }
}

