/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.queues.tiered.QueueBucket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SortedBuckets {
    private final List<QueueBucket> buckets = new ArrayList<QueueBucket>();
    private final Map<String, QueueBucket> bucketMap = new HashMap<String, QueueBucket>();
    private final Comparator<QueueBucket> comparator;
    private final UsageTrackedQueue.ResUsage parentUsage;

    SortedBuckets(final UsageTrackedQueue.ResUsage parentUsage) {
        this.comparator = new Comparator<QueueBucket>(){

            @Override
            public int compare(QueueBucket o1, QueueBucket o2) {
                return Double.compare(o1.getDominantUsageShare(parentUsage), o2.getDominantUsageShare(parentUsage));
            }
        };
        this.parentUsage = parentUsage;
    }

    boolean add(QueueBucket bucket) {
        if (this.bucketMap.containsKey(bucket.getName())) {
            return false;
        }
        if (this.buckets.isEmpty()) {
            this.buckets.add(bucket);
        } else {
            this.buckets.add(this.findInsertionPoint(bucket, this.buckets), bucket);
        }
        this.bucketMap.put(bucket.getName(), bucket);
        return true;
    }

    QueueBucket remove(String bucketName) {
        int remPos;
        QueueBucket bucket = this.bucketMap.get(bucketName);
        if (bucket == null) {
            return null;
        }
        int index = this.findInsertionPoint(bucket, this.buckets);
        if (index < 0) {
            throw new IllegalStateException("Unexpected: bucket with name=" + bucketName + " does not exist");
        }
        int n = remPos = this.buckets.get(index).getName().equals(bucketName) ? index : -1;
        if (remPos < 0) {
            remPos = this.findWalkingLeft(this.buckets, index, bucketName, bucket.getDominantUsageShare(this.parentUsage));
        }
        if (remPos < 0) {
            remPos = this.findWalkingRight(this.buckets, index, bucketName, bucket.getDominantUsageShare(this.parentUsage));
        }
        if (remPos < 0) {
            throw new IllegalStateException("Unexpected: bucket with name=" + bucketName + " not found to remove");
        }
        this.buckets.remove(remPos);
        this.bucketMap.remove(bucketName);
        return bucket;
    }

    QueueBucket get(String bucketName) {
        return this.bucketMap.get(bucketName);
    }

    private int findWalkingRight(List<QueueBucket> buckets, int index, String bucketName, double dominantUsageShare) {
        int pos = index;
        while (++pos < buckets.size() && buckets.get(pos).getDominantUsageShare(this.parentUsage) == dominantUsageShare) {
            if (!buckets.get(pos).getName().equals(bucketName)) continue;
            return pos;
        }
        return -1;
    }

    private int findWalkingLeft(List<QueueBucket> buckets, int index, String bucketName, double dominantUsageShare) {
        int pos = index;
        while (--pos >= 0 && buckets.get(pos).getDominantUsageShare(this.parentUsage) == dominantUsageShare) {
            if (!buckets.get(pos).getName().equals(bucketName)) continue;
            return pos;
        }
        return -1;
    }

    private int findInsertionPoint(QueueBucket bucket, List<QueueBucket> buckets) {
        int i = Collections.binarySearch(buckets, bucket, this.comparator);
        if (i >= 0) {
            return i;
        }
        return -i - 1;
    }

    List<QueueBucket> getSortedList() {
        return Collections.unmodifiableList(this.buckets);
    }
}

