/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.UsageTrackedQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueBucket
implements UsageTrackedQueue {
    private static final Logger logger = LoggerFactory.getLogger(QueueBucket.class);
    private final int tierNumber;
    private final String name;
    private final UsageTrackedQueue.ResUsage totals;
    private final LinkedHashMap<String, QueuableTask> queuedTasks;
    private final LinkedHashMap<String, QueuableTask> launchedTasks;
    private final LinkedHashMap<String, QueuableTask> assignedTasks;
    private Iterator<Map.Entry<String, QueuableTask>> iterator = null;

    QueueBucket(int tierNumber, String name) {
        this.tierNumber = tierNumber;
        this.name = name;
        this.totals = new UsageTrackedQueue.ResUsage();
        this.queuedTasks = new LinkedHashMap();
        this.launchedTasks = new LinkedHashMap();
        this.assignedTasks = new LinkedHashMap();
    }

    @Override
    public void queueTask(QueuableTask t) throws TaskQueueException {
        if (this.iterator != null) {
            throw new ConcurrentModificationException("Must reset before queuing tasks");
        }
        if (this.queuedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Duplicate task not allowed, task with id " + t.getId());
        }
        if (this.launchedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already launched, can't queue, id=" + t.getId());
        }
        this.queuedTasks.put(t.getId(), t);
    }

    @Override
    public QueuableTask nextTaskToLaunch() throws TaskQueueException {
        if (this.iterator == null) {
            this.iterator = this.queuedTasks.entrySet().iterator();
            if (!this.assignedTasks.isEmpty()) {
                throw new TaskQueueException(this.assignedTasks.size() + " tasks still assigned but not launched");
            }
        }
        if (this.iterator.hasNext()) {
            return this.iterator.next().getValue();
        }
        return null;
    }

    @Override
    public void assignTask(QueuableTask t) throws TaskQueueException {
        if (this.iterator == null) {
            throw new TaskQueueException(new IllegalStateException("assign called while not iterating over tasks"));
        }
        if (this.queuedTasks.get(t.getId()) == null) {
            throw new TaskQueueException("Task not in queue for assigning, id=" + t.getId());
        }
        if (this.assignedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already assigned, id=" + t.getId());
        }
        if (this.launchedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already launched, id=" + t.getId());
        }
        this.assignedTasks.put(t.getId(), t);
        this.totals.addUsage(t);
    }

    @Override
    public boolean launchTask(QueuableTask t) throws TaskQueueException {
        if (this.iterator != null) {
            throw new ConcurrentModificationException("Must reset before launching tasks");
        }
        if (this.launchedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already launched, id=" + t.getId());
        }
        this.queuedTasks.remove(t.getId());
        QueuableTask removed = (QueuableTask)this.assignedTasks.remove(t.getId());
        this.launchedTasks.put(t.getId(), t);
        if (removed == null) {
            this.totals.addUsage(t);
            return true;
        }
        return false;
    }

    @Override
    public QueuableTask removeTask(String id, QAttributes qAttributes) throws TaskQueueException {
        if (this.iterator != null) {
            throw new TaskQueueException("Must reset before removing tasks");
        }
        QueuableTask removed = (QueuableTask)this.queuedTasks.remove(id);
        if (removed == null) {
            removed = (QueuableTask)this.assignedTasks.remove(id);
            if (removed == null) {
                removed = (QueuableTask)this.launchedTasks.remove(id);
            }
            if (removed != null) {
                this.totals.remUsage(removed);
            }
        }
        return removed;
    }

    @Override
    public double getDominantUsageShare(UsageTrackedQueue.ResUsage parentUsage) {
        return this.totals.getDominantUsageShareFrom(parentUsage);
    }

    @Override
    public void reset() {
        this.iterator = null;
    }

    @Override
    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() throws TaskQueueException {
        if (this.iterator != null) {
            throw new TaskQueueException("Must reset before getting list of tasks");
        }
        HashMap<TaskQueue.TaskState, Collection<QueuableTask>> result = new HashMap<TaskQueue.TaskState, Collection<QueuableTask>>();
        result.put(TaskQueue.TaskState.QUEUED, Collections.unmodifiableCollection(this.queuedTasks.values()));
        result.put(TaskQueue.TaskState.LAUNCHED, Collections.unmodifiableCollection(this.launchedTasks.values()));
        return result;
    }

    int size() {
        return this.queuedTasks.size() + this.launchedTasks.size();
    }

    int getTierNumber() {
        return this.tierNumber;
    }

    String getName() {
        return this.name;
    }
}

