/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.VirtualMachineLease;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMLeaseObject
implements VirtualMachineLease {
    private static final Logger logger = LoggerFactory.getLogger(VMLeaseObject.class);
    private final Protos.Offer offer;
    private final String hostname;
    private final String vmID;
    private final Map<String, Protos.Attribute> attributeMap;
    private final Map<String, Double> scalarResources;
    private final Map<String, List<VirtualMachineLease.Range>> rangeResources;
    private final long offeredTime;

    public VMLeaseObject(Protos.Offer offer) {
        this.offer = offer;
        this.hostname = offer.getHostname();
        this.vmID = offer.getSlaveId().getValue();
        this.offeredTime = System.currentTimeMillis();
        this.scalarResources = new HashMap<String, Double>();
        this.rangeResources = new HashMap<String, List<VirtualMachineLease.Range>>();
        block4: for (Protos.Resource resource : offer.getResourcesList()) {
            switch (resource.getType()) {
                case SCALAR: {
                    this.scalarResources.put(resource.getName(), resource.getScalar().getValue());
                    continue block4;
                }
                case RANGES: {
                    ArrayList<VirtualMachineLease.Range> ranges = new ArrayList<VirtualMachineLease.Range>();
                    for (Protos.Value.Range range : resource.getRanges().getRangeList()) {
                        ranges.add(new VirtualMachineLease.Range((int)range.getBegin(), (int)range.getEnd()));
                    }
                    this.rangeResources.put(resource.getName(), ranges);
                    continue block4;
                }
            }
            logger.debug("Unknown resource type " + resource.getType() + " for resource " + resource.getName() + " in offer, hostname=" + this.hostname + ", offerId=" + offer.getId());
        }
        this.attributeMap = new HashMap<String, Protos.Attribute>();
        if (offer.getAttributesCount() > 0) {
            for (Protos.Attribute attribute : offer.getAttributesList()) {
                this.attributeMap.put(attribute.getName(), attribute);
            }
        }
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public String getVMID() {
        return this.vmID;
    }

    @Override
    public double cpuCores() {
        return this.scalarResources.get("cpus") == null ? 0.0 : this.scalarResources.get("cpus");
    }

    @Override
    public double memoryMB() {
        return this.scalarResources.get("mem") == null ? 0.0 : this.scalarResources.get("mem");
    }

    @Override
    public double networkMbps() {
        return this.scalarResources.get("network") == null ? 0.0 : this.scalarResources.get("network");
    }

    @Override
    public double diskMB() {
        return this.scalarResources.get("disk") == null ? 0.0 : this.scalarResources.get("disk");
    }

    @Override
    public Protos.Offer getOffer() {
        return this.offer;
    }

    @Override
    public String getId() {
        return this.offer.getId().getValue();
    }

    @Override
    public long getOfferedTime() {
        return this.offeredTime;
    }

    @Override
    public List<VirtualMachineLease.Range> portRanges() {
        return this.rangeResources.get("ports") == null ? Collections.emptyList() : this.rangeResources.get("ports");
    }

    @Override
    public Map<String, Protos.Attribute> getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    public Double getScalarValue(String name) {
        return this.scalarResources.get(name);
    }

    @Override
    public Map<String, Double> getScalarValues() {
        return Collections.unmodifiableMap(this.scalarResources);
    }

    public String toString() {
        return "VMLeaseObject{offer=" + this.offer + ", scalars: " + this.scalarResources.toString() + ", ranges: " + this.rangeResources.toString() + ", hostname='" + this.hostname + '\'' + ", vmID='" + this.vmID + '\'' + ", attributeMap=" + this.attributeMap + ", offeredTime=" + this.offeredTime + '}';
    }
}

