/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.sla.ResAllocs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTracker {
    private static final Logger logger = LoggerFactory.getLogger(TaskTracker.class);
    private final Map<String, ActiveTask> runningTasks = new HashMap<String, ActiveTask>();
    private final Map<String, ActiveTask> assignedTasks = new HashMap<String, ActiveTask>();
    private final Map<String, TaskGroupUsage> taskGroupUsages = new HashMap<String, TaskGroupUsage>();
    private UsageTrackedQueue usageTrackedQueue = null;

    TaskTracker() {
    }

    public void setUsageTrackedQueue(UsageTrackedQueue t) {
        this.usageTrackedQueue = t;
    }

    boolean addRunningTask(TaskRequest request, AssignableVirtualMachine avm) {
        boolean added;
        boolean bl = added = this.runningTasks.put(request.getId(), new ActiveTask(request, avm)) == null;
        if (added) {
            this.addUsage(request);
            if (this.usageTrackedQueue != null && request instanceof QueuableTask) {
                try {
                    this.usageTrackedQueue.launchTask((QueuableTask)request);
                }
                catch (TaskQueueException e) {
                    logger.warn("Unexpected: " + e.getMessage());
                }
            }
        }
        return added;
    }

    boolean removeRunningTask(String taskId) {
        ActiveTask removed = this.runningTasks.remove(taskId);
        if (removed != null) {
            TaskRequest task = removed.getTaskRequest();
            TaskGroupUsage usage = this.taskGroupUsages.get(task.taskGroupName());
            if (usage == null) {
                logger.warn("Unexpected to not find usage for task group " + task.taskGroupName() + " to unqueueTask usage of task " + task.getId());
            } else {
                usage.subtractUsage(task);
            }
            if (this.usageTrackedQueue != null && removed.getTaskRequest() instanceof QueuableTask) {
                try {
                    QueuableTask queuableTask = (QueuableTask)removed.getTaskRequest();
                    this.usageTrackedQueue.removeTask(queuableTask.getId(), queuableTask.getQAttributes());
                }
                catch (TaskQueueException e) {
                    logger.warn("Unexpected: " + e.getMessage());
                }
            }
        }
        return removed != null;
    }

    Map<String, ActiveTask> getAllRunningTasks() {
        return Collections.unmodifiableMap(this.runningTasks);
    }

    boolean addAssignedTask(TaskRequest request, AssignableVirtualMachine avm) {
        boolean assigned;
        boolean bl = assigned = this.assignedTasks.put(request.getId(), new ActiveTask(request, avm)) == null;
        if (assigned) {
            this.addUsage(request);
            if (this.usageTrackedQueue != null && request instanceof QueuableTask) {
                try {
                    this.usageTrackedQueue.assignTask((QueuableTask)request);
                }
                catch (TaskQueueException e) {
                    logger.warn("Unexpected: " + e.getMessage());
                }
            }
        }
        return assigned;
    }

    private void addUsage(TaskRequest request) {
        TaskGroupUsage usage = this.taskGroupUsages.get(request.taskGroupName());
        if (usage == null) {
            this.taskGroupUsages.put(request.taskGroupName(), new TaskGroupUsage(request.taskGroupName()));
            usage = this.taskGroupUsages.get(request.taskGroupName());
        }
        usage.addUsage(request);
    }

    void clearAssignedTasks() {
        for (ActiveTask t : this.assignedTasks.values()) {
            this.taskGroupUsages.get(t.getTaskRequest().taskGroupName()).subtractUsage(t.getTaskRequest());
        }
        this.assignedTasks.clear();
    }

    Map<String, ActiveTask> getAllAssignedTasks() {
        return Collections.unmodifiableMap(this.assignedTasks);
    }

    TaskGroupUsage getUsage(String taskGroupName) {
        return this.taskGroupUsages.get(taskGroupName);
    }

    public static class ActiveTask {
        private TaskRequest taskRequest;
        private AssignableVirtualMachine avm;

        public ActiveTask(TaskRequest taskRequest, AssignableVirtualMachine avm) {
            this.taskRequest = taskRequest;
            this.avm = avm;
        }

        public TaskRequest getTaskRequest() {
            return this.taskRequest;
        }

        public VirtualMachineLease getTotalLease() {
            return this.avm.getCurrTotalLease();
        }
    }

    static class TaskGroupUsage
    implements ResAllocs {
        private final String taskGroupName;
        private double cores = 0.0;
        private double memory = 0.0;
        private double networkMbps = 0.0;
        private double disk = 0.0;

        private TaskGroupUsage(String taskGroupName) {
            this.taskGroupName = taskGroupName;
        }

        @Override
        public String getTaskGroupName() {
            return this.taskGroupName;
        }

        @Override
        public double getCores() {
            return this.cores;
        }

        @Override
        public double getMemory() {
            return this.memory;
        }

        @Override
        public double getNetworkMbps() {
            return this.networkMbps;
        }

        @Override
        public double getDisk() {
            return this.disk;
        }

        void addUsage(TaskRequest task) {
            this.cores += task.getCPUs();
            this.memory += task.getMemory();
            this.networkMbps += task.getNetworkMbps();
            this.disk += task.getDisk();
        }

        void subtractUsage(TaskRequest task) {
            this.cores -= task.getCPUs();
            if (this.cores < 0.0) {
                logger.warn("correcting cores usage <0.0");
                this.cores = 0.0;
            }
            this.memory -= task.getMemory();
            if (this.memory < 0.0) {
                logger.warn("correcting memory usage<0.0");
                this.memory = 0.0;
            }
            this.networkMbps -= task.getNetworkMbps();
            if (this.networkMbps < 0.0) {
                logger.warn("correcting networkMbps usage<0.0");
                this.networkMbps = 0.0;
            }
            this.disk -= task.getDisk();
            if (this.disk < 0.0) {
                logger.warn("correcting disk usage<0.0");
                this.disk = 0.0;
            }
        }
    }
}

