/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.SchedulingResult;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskScheduler;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action0;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.queues.InternalTaskQueue;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSchedulingService {
    private static final Logger logger = LoggerFactory.getLogger(TaskSchedulingService.class);
    private final TaskScheduler taskScheduler;
    private final Action1<SchedulingResult> schedulingResultCallback;
    private final InternalTaskQueue taskQueue;
    private final ScheduledExecutorService executorService;
    private final long loopIntervalMillis;
    private final Action0 preHook;
    private final BlockingQueue<VirtualMachineLease> leaseBlockingQueue = new LinkedBlockingQueue<VirtualMachineLease>();
    private final BlockingQueue<Map<String, QueuableTask>> addRunningTasksQueue = new LinkedBlockingQueue<Map<String, QueuableTask>>();
    private final BlockingQueue<Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>>> taskMapRequest = new LinkedBlockingQueue<Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>>>(10);
    private final BlockingQueue<Action1<Map<String, Map<VMResource, Double[]>>>> resStatusRequest = new LinkedBlockingQueue<Action1<Map<String, Map<VMResource, Double[]>>>>(10);
    private final BlockingQueue<Action1<List<VirtualMachineCurrentState>>> vmCurrStateRequest = new LinkedBlockingQueue<Action1<List<VirtualMachineCurrentState>>>(10);
    private final AtomicLong lastSchedIterationAt = new AtomicLong();
    private final long maxSchedIterDelay;

    private TaskSchedulingService(Builder builder) {
        this.taskScheduler = builder.taskScheduler;
        this.schedulingResultCallback = builder.schedulingResultCallback;
        this.taskQueue = builder.taskQueue;
        this.taskScheduler.getTaskTracker().setUsageTrackedQueue(this.taskQueue.getUsageTracker());
        this.taskScheduler.setUsingSchedulingService(true);
        this.executorService = builder.executorService;
        this.loopIntervalMillis = builder.loopIntervalMillis;
        this.preHook = builder.preHook;
        this.maxSchedIterDelay = Math.max(builder.maxDelayMillis, this.loopIntervalMillis);
    }

    public void start() {
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TaskSchedulingService.this.scheduleOnce();
            }
        }, 0L, this.loopIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    private void scheduleOnce() {
        try {
            this.taskScheduler.checkIfShutdown();
        }
        catch (IllegalStateException e) {
            logger.warn("Shutting down due to taskScheduler being shutdown");
            this.shutdown();
            return;
        }
        try {
            boolean newLeaseExists;
            boolean qModified = this.taskQueue.reset();
            this.addPendingRunningTasks();
            boolean bl = newLeaseExists = this.leaseBlockingQueue.peek() != null;
            if (qModified || newLeaseExists || this.doNextIteration()) {
                this.lastSchedIterationAt.set(System.currentTimeMillis());
                if (this.preHook != null) {
                    this.preHook.call();
                }
                ArrayList<VirtualMachineLease> currentLeases = new ArrayList<VirtualMachineLease>();
                this.leaseBlockingQueue.drainTo(currentLeases);
                SchedulingResult schedulingResult = this.taskScheduler.scheduleOnce(this.taskQueue, currentLeases);
                this.taskQueue.getUsageTracker().reset();
                this.assignTasks(schedulingResult, this.taskScheduler);
                this.schedulingResultCallback.call(schedulingResult);
                this.doPendingActions();
            }
        }
        catch (Exception e) {
            SchedulingResult result = new SchedulingResult(null);
            result.addException(e);
            this.schedulingResultCallback.call(result);
        }
    }

    private void addPendingRunningTasks() {
        if (this.addRunningTasksQueue.peek() != null) {
            LinkedList r = new LinkedList();
            this.addRunningTasksQueue.drainTo(r);
            for (Map m : r) {
                for (Map.Entry entry : m.entrySet()) {
                    this.taskScheduler.getTaskAssigner().call((TaskRequest)entry.getValue(), (String)entry.getKey());
                }
            }
        }
    }

    private void doPendingActions() {
        Action1 action = (Action1)this.taskMapRequest.poll();
        try {
            if (action != null) {
                action.call(this.taskQueue.getAllTasks());
            }
        }
        catch (TaskQueueException e) {
            logger.warn("Unexpected when trying to get task list: " + e.getMessage(), (Throwable)e);
        }
        Action1 rsAction = (Action1)this.resStatusRequest.poll();
        try {
            if (rsAction != null) {
                rsAction.call(this.taskScheduler.getResourceStatus());
            }
        }
        catch (IllegalStateException e) {
            logger.warn("Unexpected when trying to get resource status: " + e.getMessage(), (Throwable)e);
        }
        Action1 vmcAction = (Action1)this.vmCurrStateRequest.poll();
        try {
            if (vmcAction != null) {
                vmcAction.call(this.taskScheduler.getVmCurrentStatesIntl());
            }
        }
        catch (IllegalStateException e) {
            logger.warn("Unexpected when trying to get vm current states: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean doNextIteration() {
        return System.currentTimeMillis() - this.lastSchedIterationAt.get() > this.maxSchedIterDelay;
    }

    private void assignTasks(SchedulingResult schedulingResult, TaskScheduler taskScheduler) {
        if (!schedulingResult.getResultMap().isEmpty()) {
            for (VMAssignmentResult result : schedulingResult.getResultMap().values()) {
                for (TaskAssignmentResult t : result.getTasksAssigned()) {
                    taskScheduler.getTaskAssignerIntl().call(t.getRequest(), result.getHostname());
                }
            }
        }
    }

    public void addLeases(List<? extends VirtualMachineLease> leases) {
        if (leases != null && !leases.isEmpty()) {
            for (VirtualMachineLease virtualMachineLease : leases) {
                this.leaseBlockingQueue.offer(virtualMachineLease);
            }
        }
    }

    public void requestAllTasks(Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>> action) throws TaskQueueException {
        if (!this.taskMapRequest.offer(action)) {
            throw new TaskQueueException("Too many pending actions submitted for getting tasks collection");
        }
    }

    public void requestResourceStatus(Action1<Map<String, Map<VMResource, Double[]>>> action) throws TaskQueueException {
        if (!this.resStatusRequest.offer(action)) {
            throw new TaskQueueException("Too many pending actions submitted for getting resource status");
        }
    }

    public void requestVmCurrentStates(Action1<List<VirtualMachineCurrentState>> action) throws TaskQueueException {
        if (!this.vmCurrStateRequest.offer(action)) {
            throw new TaskQueueException("Too many pending actions submitted for getting VM current state");
        }
    }

    public void initializeRunningTask(QueuableTask task, String hostname) {
        this.addRunningTasksQueue.offer(Collections.singletonMap(hostname, task));
    }

    public static final class Builder {
        private TaskScheduler taskScheduler = null;
        private Action1<SchedulingResult> schedulingResultCallback = null;
        private InternalTaskQueue taskQueue = null;
        private long loopIntervalMillis = 50L;
        private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1);
        private Action0 preHook = null;
        private long maxDelayMillis = 5000L;

        public Builder withTaskScheduler(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
            return this;
        }

        public Builder withSchedulingResultCallback(Action1<SchedulingResult> callback) {
            this.schedulingResultCallback = callback;
            return this;
        }

        public Builder withTaskQuue(TaskQueue taskQ) {
            if (!(taskQ instanceof InternalTaskQueue)) {
                throw new IllegalArgumentException("Argument is not a valid implementation of task queue");
            }
            this.taskQueue = (InternalTaskQueue)taskQ;
            return this;
        }

        public Builder withLoopIntervalMillis(long loopIntervalMillis) {
            this.loopIntervalMillis = loopIntervalMillis;
            return this;
        }

        public Builder withMaxDelayMillis(long maxDelayMillis) {
            this.maxDelayMillis = maxDelayMillis;
            return this;
        }

        public Builder withPreSchedulingLoopHook(Action0 preHook) {
            this.preHook = preHook;
            return this;
        }

        public TaskSchedulingService build() {
            if (this.taskScheduler == null) {
                throw new NullPointerException("Null task scheduler not allowed");
            }
            if (this.schedulingResultCallback == null) {
                throw new NullPointerException("Null scheduling result callback not allowed");
            }
            if (this.taskQueue == null) {
                throw new NullPointerException("Null task queue not allowed");
            }
            return new TaskSchedulingService(this);
        }
    }
}

