/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.ActiveVmGroups;
import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTracker;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssignableVMs {
    private final ConcurrentMap<String, AssignableVirtualMachine> virtualMachinesMap;
    private final Action1<VirtualMachineLease> leaseRejectAction;
    private final long leaseOfferExpirySecs;
    private static final Logger logger = LoggerFactory.getLogger(AssignableVMs.class);
    private final ConcurrentMap<String, String> leaseIdToHostnameMap = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> vmIdToHostnameMap = new ConcurrentHashMap<String, String>();
    private final TaskTracker taskTracker;
    private final String attrNameToGroupMaxResources;
    private final Map<String, Map<VMResource, Double>> maxResourcesMap;
    private final VMRejectLimiter vmRejectLimiter;
    private final AssignableVirtualMachine dummyVM = new AssignableVirtualMachine(null, null, "", null, 0L, null){

        @Override
        void assignResult(TaskAssignmentResult result) {
            throw new UnsupportedOperationException();
        }
    };
    private final ActiveVmGroups activeVmGroups;
    private String activeVmGroupAttributeName = null;
    private final List<String> unknownLeaseIdsToExpire = new ArrayList<String>();
    private final boolean singleLeaseMode;

    AssignableVMs(TaskTracker taskTracker, Action1<VirtualMachineLease> leaseRejectAction, long leaseOfferExpirySecs, int maxOffersToReject, String attrNameToGroupMaxResources, boolean singleLeaseMode) {
        this.taskTracker = taskTracker;
        this.virtualMachinesMap = new ConcurrentHashMap<String, AssignableVirtualMachine>();
        this.leaseRejectAction = leaseRejectAction;
        this.leaseOfferExpirySecs = leaseOfferExpirySecs;
        this.attrNameToGroupMaxResources = attrNameToGroupMaxResources;
        this.maxResourcesMap = new HashMap<String, Map<VMResource, Double>>();
        this.vmRejectLimiter = new VMRejectLimiter(maxOffersToReject, leaseOfferExpirySecs);
        this.activeVmGroups = new ActiveVmGroups();
        this.singleLeaseMode = singleLeaseMode;
    }

    Map<String, Map<VMResource, Double[]>> getResourceStatus() {
        HashMap<String, Map<VMResource, Double[]>> result = new HashMap<String, Map<VMResource, Double[]>>();
        for (AssignableVirtualMachine avm : this.virtualMachinesMap.values()) {
            result.put(avm.getHostname(), avm.getResourceStatus());
        }
        return result;
    }

    void setTaskAssigned(TaskRequest request, String host) {
        this.createAvmIfAbsent(host);
        AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(host);
        avm.setAssignedTask(request);
    }

    void unAssignTask(String taskId, String host) {
        AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(host);
        if (avm != null) {
            avm.markTaskForUnassigning(taskId);
        } else {
            logger.warn("No VM for host " + host + " to unassign task " + taskId);
        }
    }

    private int addLeases(List<VirtualMachineLease> leases) {
        for (AssignableVirtualMachine avm : this.virtualMachinesMap.values()) {
            avm.resetResources();
        }
        int rejected = 0;
        for (VirtualMachineLease l : leases) {
            String host = l.hostname();
            this.createAvmIfAbsent(host);
            if (((AssignableVirtualMachine)this.virtualMachinesMap.get(host)).addLease(l)) continue;
            ++rejected;
        }
        for (AssignableVirtualMachine avm : this.virtualMachinesMap.values()) {
            avm.updateCurrTotalLease();
        }
        return rejected;
    }

    private void createAvmIfAbsent(String hostname) {
        if (this.virtualMachinesMap.get(hostname) == null) {
            this.virtualMachinesMap.putIfAbsent(hostname, new AssignableVirtualMachine(this.vmIdToHostnameMap, this.leaseIdToHostnameMap, hostname, this.leaseRejectAction, this.leaseOfferExpirySecs, this.taskTracker, this.singleLeaseMode));
        }
    }

    void expireLease(String leaseId) {
        String hostname = (String)this.leaseIdToHostnameMap.get(leaseId);
        if (hostname == null) {
            this.unknownLeaseIdsToExpire.add(leaseId);
            return;
        }
        this.internalExpireLease(leaseId, hostname);
    }

    private void internalExpireLease(String leaseId, String hostname) {
        AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(hostname);
        if (avm != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Expiring lease offer id " + leaseId + " on host " + hostname);
            }
            avm.expireLease(leaseId);
        }
    }

    void expireAllLeases(String hostname) {
        AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(hostname);
        if (avm != null) {
            avm.expireAllLeases();
        }
    }

    void expireAllLeases() {
        for (AssignableVirtualMachine avm : this.virtualMachinesMap.values()) {
            avm.expireAllLeases();
        }
    }

    void disableUntil(String host, long until) {
        this.createAvmIfAbsent(host);
        AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(host);
        avm.setDisabledUntil(until);
    }

    void enableVM(String host) {
        AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(host);
        if (avm != null) {
            avm.enable();
        } else {
            logger.warn("Can't enable host " + host + ", no such host");
        }
    }

    String getHostnameFromVMId(String vmId) {
        return (String)this.vmIdToHostnameMap.get(vmId);
    }

    void setActiveVmGroupAttributeName(String attributeName) {
        this.activeVmGroupAttributeName = attributeName;
    }

    void setActiveVmGroups(List<String> vmGroups) {
        this.activeVmGroups.setActiveVmGroups(vmGroups);
    }

    private boolean isInActiveVmGroup(AssignableVirtualMachine avm) {
        String attrValue = avm.getAttrValue(this.activeVmGroupAttributeName);
        return this.activeVmGroups.isActiveVmGroup(attrValue, false);
    }

    private void expireAnyUnknownLeaseIds() {
        if (!this.unknownLeaseIdsToExpire.isEmpty()) {
            for (String leaseId : this.unknownLeaseIdsToExpire) {
                String hostname = (String)this.leaseIdToHostnameMap.get(leaseId);
                if (hostname == null) continue;
                this.internalExpireLease(leaseId, hostname);
            }
            this.unknownLeaseIdsToExpire.clear();
        }
    }

    List<AssignableVirtualMachine> prepareAndGetOrderedVMs(List<VirtualMachineLease> newLeases, AtomicInteger rejectedCount) {
        this.expireAnyUnknownLeaseIds();
        this.removeExpiredLeases();
        rejectedCount.addAndGet(this.addLeases(newLeases));
        ArrayList<AssignableVirtualMachine> vms = new ArrayList<AssignableVirtualMachine>();
        this.taskTracker.clearAssignedTasks();
        this.vmRejectLimiter.reset();
        for (Map.Entry entry : this.virtualMachinesMap.entrySet()) {
            AssignableVirtualMachine avm = (AssignableVirtualMachine)entry.getValue();
            avm.prepareForScheduling();
            if (this.isInActiveVmGroup((AssignableVirtualMachine)entry.getValue()) && ((AssignableVirtualMachine)entry.getValue()).isAssignableNow()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Host " + avm.getHostname() + " available for assignments");
                }
                vms.add(avm);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Host " + avm.getHostname() + " not available for assignments");
            }
            this.saveMaxResources(avm);
        }
        return vms;
    }

    private void removeExpiredLeases() {
        Iterator iterator = this.virtualMachinesMap.values().iterator();
        while (iterator.hasNext()) {
            AssignableVirtualMachine avm;
            avm.removeExpiredLeases(!this.isInActiveVmGroup(avm = (AssignableVirtualMachine)iterator.next()));
        }
    }

    int removeLimitedLeases(List<VirtualMachineLease> idleResourcesList) {
        int rejected = 0;
        ArrayList<VirtualMachineLease> randomized = new ArrayList<VirtualMachineLease>(idleResourcesList);
        Collections.shuffle(randomized);
        for (VirtualMachineLease lease : randomized) {
            if (this.vmRejectLimiter.limitReached()) break;
            AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(lease.hostname());
            rejected += avm.expireLimitedLeases(this.vmRejectLimiter);
        }
        return rejected;
    }

    int getTotalNumVMs() {
        return this.virtualMachinesMap.size();
    }

    void purgeInactiveVMs() {
        for (String hostname : this.virtualMachinesMap.keySet()) {
            AssignableVirtualMachine avm = (AssignableVirtualMachine)this.virtualMachinesMap.get(hostname);
            if (avm == null || avm.isActive()) continue;
            this.virtualMachinesMap.remove(hostname, avm);
            if (avm.getCurrVMId() != null) {
                this.vmIdToHostnameMap.remove(avm.getCurrVMId(), avm.getHostname());
            }
            logger.info("Removed inactive host " + hostname);
        }
    }

    private void saveMaxResources(AssignableVirtualMachine avm) {
        String attrValue;
        if (this.attrNameToGroupMaxResources != null && !this.attrNameToGroupMaxResources.isEmpty() && (attrValue = avm.getAttrValue(this.attrNameToGroupMaxResources)) != null) {
            Map<VMResource, Double> maxResources = avm.getMaxResources();
            Map<VMResource, Double> savedMaxResources = this.maxResourcesMap.get(attrValue);
            if (savedMaxResources == null) {
                savedMaxResources = new HashMap<VMResource, Double>();
                this.maxResourcesMap.put(attrValue, savedMaxResources);
            }
            for (VMResource r : VMResource.values()) {
                switch (r) {
                    case CPU: 
                    case Disk: 
                    case Memory: 
                    case Ports: 
                    case Network: {
                        Double savedVal = savedMaxResources.get((Object)r) == null ? 0.0 : savedMaxResources.get((Object)r);
                        savedMaxResources.put(r, Math.max(savedVal, maxResources.get((Object)r)));
                    }
                }
            }
        }
    }

    Map<VMResource, Double> getMaxResources(String attrValue) {
        return this.maxResourcesMap.get(attrValue);
    }

    AssignmentFailure getFailedMaxResource(String attrValue, TaskRequest task) {
        AssignmentFailure savedFailure = null;
        for (Map.Entry<String, Map<VMResource, Double>> entry : this.maxResourcesMap.entrySet()) {
            if (attrValue != null && !attrValue.equals(entry.getKey())) continue;
            Map<VMResource, Double> maxResources = entry.getValue();
            AssignmentFailure failure = null;
            for (VMResource res : VMResource.values()) {
                switch (res) {
                    case CPU: {
                        if (!(maxResources.get((Object)VMResource.CPU) < task.getCPUs())) break;
                        failure = new AssignmentFailure(VMResource.CPU, task.getCPUs(), 0.0, maxResources.get((Object)VMResource.CPU), "");
                        break;
                    }
                    case Memory: {
                        if (!(maxResources.get((Object)VMResource.Memory) < task.getMemory())) break;
                        failure = new AssignmentFailure(VMResource.Memory, task.getMemory(), 0.0, maxResources.get((Object)VMResource.Memory), "");
                        break;
                    }
                    case Disk: {
                        if (!(maxResources.get((Object)VMResource.Disk) < task.getDisk())) break;
                        failure = new AssignmentFailure(VMResource.Disk, task.getDisk(), 0.0, maxResources.get((Object)VMResource.Disk), "");
                        break;
                    }
                    case Ports: {
                        if (!(maxResources.get((Object)VMResource.Ports) < (double)task.getPorts())) break;
                        failure = new AssignmentFailure(VMResource.Ports, task.getPorts(), 0.0, maxResources.get((Object)VMResource.Ports), "");
                        break;
                    }
                    case Network: {
                        if (!(maxResources.get((Object)VMResource.Network) < task.getNetworkMbps())) break;
                        failure = new AssignmentFailure(VMResource.Network, task.getNetworkMbps(), 0.0, maxResources.get((Object)VMResource.Network), "");
                        break;
                    }
                    case VirtualMachine: 
                    case Fitness: 
                    case ResAllocs: 
                    case ResourceSet: {
                        break;
                    }
                    default: {
                        logger.error("Unknown resource type: " + (Object)((Object)res));
                    }
                }
                if (failure != null) break;
            }
            if (failure == null) {
                return null;
            }
            savedFailure = failure;
        }
        return savedFailure;
    }

    ActiveVmGroups getActiveVmGroups() {
        return this.activeVmGroups;
    }

    List<VirtualMachineCurrentState> getVmCurrentStates() {
        ArrayList<VirtualMachineCurrentState> result = new ArrayList<VirtualMachineCurrentState>();
        for (AssignableVirtualMachine avm : this.virtualMachinesMap.values()) {
            result.add(avm.getVmCurrentState());
        }
        return result;
    }

    AssignableVirtualMachine getDummyVM() {
        return this.dummyVM;
    }

    static class VMRejectLimiter {
        private long lastRejectAt = 0L;
        private int rejectedCount;
        private final int limit;
        private final long rejectDelay;

        VMRejectLimiter(int limit, long leaseOfferExpirySecs) {
            this.limit = limit;
            this.rejectDelay = leaseOfferExpirySecs * 1000L;
        }

        synchronized boolean reject() {
            if (this.rejectedCount == this.limit) {
                return false;
            }
            ++this.rejectedCount;
            this.lastRejectAt = System.currentTimeMillis();
            return true;
        }

        boolean limitReached() {
            return this.rejectedCount == this.limit;
        }

        private void reset() {
            if (System.currentTimeMillis() > this.lastRejectAt + this.rejectDelay) {
                this.rejectedCount = 0;
            }
        }
    }
}

