/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running.RunningService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.AbstractStatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.util.StatisticTimeUtils;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.rdb.StatisticRdbRepository;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskRunningStatistics;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobRunningStatisticJob
extends AbstractStatisticJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobRunningStatisticJob.class);
    private static final StatisticInterval EXECUTE_INTERVAL = StatisticInterval.MINUTE;
    private RunningService runningService;
    private StatisticRdbRepository repository;

    public JobRunningStatisticJob(CoordinatorRegistryCenter registryCenter, StatisticRdbRepository rdbRepository) {
        this.runningService = new RunningService(registryCenter);
        this.repository = rdbRepository;
    }

    @Override
    public JobDetail buildJobDetail() {
        return JobBuilder.newJob(this.getClass()).withIdentity(this.getJobName()).build();
    }

    @Override
    public Trigger buildTrigger() {
        return TriggerBuilder.newTrigger().withIdentity(this.getTriggerName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)EXECUTE_INTERVAL.getCron()).withMisfireHandlingInstructionDoNothing()).build();
    }

    @Override
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("runningService", this.runningService);
        result.put("repository", this.repository);
        return result;
    }

    public void execute(JobExecutionContext context) {
        Map<String, Set<TaskContext>> allRunningTasks = this.runningService.getAllRunningTasks();
        this.statisticJob(this.getJobRunningCount(allRunningTasks));
        this.statisticTask(this.getTaskRunningCount(allRunningTasks));
    }

    private void statisticJob(int runningCount) {
        Optional latestOne = this.repository.findLatestJobRunningStatistics();
        latestOne.ifPresent(this::fillBlankIfNeeded);
        JobRunningStatistics jobRunningStatistics = new JobRunningStatistics(runningCount, StatisticTimeUtils.getCurrentStatisticTime(EXECUTE_INTERVAL));
        log.debug("Add jobRunningStatistics, runningCount is:{}", (Object)runningCount);
        this.repository.add(jobRunningStatistics);
    }

    private void statisticTask(int runningCount) {
        Optional latestOne = this.repository.findLatestTaskRunningStatistics();
        latestOne.ifPresent(this::fillBlankIfNeeded);
        TaskRunningStatistics taskRunningStatistics = new TaskRunningStatistics(runningCount, StatisticTimeUtils.getCurrentStatisticTime(EXECUTE_INTERVAL));
        log.debug("Add taskRunningStatistics, runningCount is:{}", (Object)runningCount);
        this.repository.add(taskRunningStatistics);
    }

    private int getJobRunningCount(Map<String, Set<TaskContext>> allRunningTasks) {
        int result = 0;
        for (Map.Entry<String, Set<TaskContext>> entry : allRunningTasks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            ++result;
        }
        return result;
    }

    private int getTaskRunningCount(Map<String, Set<TaskContext>> allRunningTasks) {
        int result = 0;
        for (Map.Entry<String, Set<TaskContext>> entry : allRunningTasks.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    private void fillBlankIfNeeded(JobRunningStatistics latestOne) {
        List<Date> blankDateRange = this.findBlankStatisticTimes(latestOne.getStatisticsTime(), EXECUTE_INTERVAL);
        if (!blankDateRange.isEmpty()) {
            log.debug("Fill blank range of jobRunningStatistics, range is:{}", blankDateRange);
        }
        for (Date each : blankDateRange) {
            this.repository.add(new JobRunningStatistics(latestOne.getRunningCount(), each));
        }
    }

    private void fillBlankIfNeeded(TaskRunningStatistics latestOne) {
        List<Date> blankDateRange = this.findBlankStatisticTimes(latestOne.getStatisticsTime(), EXECUTE_INTERVAL);
        if (!blankDateRange.isEmpty()) {
            log.debug("Fill blank range of taskRunningStatistics, range is:{}", blankDateRange);
        }
        for (Date each : blankDateRange) {
            this.repository.add(new TaskRunningStatistics(latestOne.getRunningCount(), each));
        }
    }

    @Generated
    public void setRunningService(RunningService runningService) {
        this.runningService = runningService;
    }

    @Generated
    public void setRepository(StatisticRdbRepository repository) {
        this.repository = repository;
    }

    @Generated
    public JobRunningStatisticJob() {
    }
}

