/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running.RunningNode;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class RunningService {
    private static final int TASK_INITIAL_SIZE = 1024;
    private static final ConcurrentHashMap<String, Set<TaskContext>> RUNNING_TASKS = new ConcurrentHashMap(1024);
    private static final ConcurrentHashMap<String, String> TASK_HOSTNAME_MAPPER = new ConcurrentHashMap(1024);
    private final CoordinatorRegistryCenter regCenter;
    private final CloudJobConfigurationService configurationService;

    public RunningService(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
        this.configurationService = new CloudJobConfigurationService(regCenter);
    }

    public void start() {
        this.clear();
        List jobKeys = this.regCenter.getChildrenKeys("/state/running");
        for (String each : jobKeys) {
            if (!this.configurationService.load(each).isPresent()) {
                this.remove(each);
                continue;
            }
            RUNNING_TASKS.put(each, Sets.newCopyOnWriteArraySet((Iterable)this.regCenter.getChildrenKeys(RunningNode.getRunningJobNodePath(each)).stream().map(input -> TaskContext.from((String)this.regCenter.get(RunningNode.getRunningTaskNodePath(TaskContext.MetaInfo.from((String)input).toString())))).collect(Collectors.toList())));
        }
    }

    public void add(TaskContext taskContext) {
        if (!this.configurationService.load(taskContext.getMetaInfo().getJobName()).isPresent()) {
            return;
        }
        this.getRunningTasks(taskContext.getMetaInfo().getJobName()).add(taskContext);
        if (!this.isDaemon(taskContext.getMetaInfo().getJobName())) {
            return;
        }
        String runningTaskNodePath = RunningNode.getRunningTaskNodePath(taskContext.getMetaInfo().toString());
        if (!this.regCenter.isExisted(runningTaskNodePath)) {
            this.regCenter.persist(runningTaskNodePath, taskContext.getId());
        }
    }

    private boolean isDaemon(String jobName) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configurationService.load(jobName);
        return cloudJobConfig.isPresent() && CloudJobExecutionType.DAEMON == cloudJobConfig.get().getJobExecutionType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIdle(TaskContext taskContext, boolean isIdle) {
        ConcurrentHashMap<String, Set<TaskContext>> concurrentHashMap = RUNNING_TASKS;
        synchronized (concurrentHashMap) {
            Optional<TaskContext> taskContextOptional = this.findTask(taskContext);
            if (taskContextOptional.isPresent()) {
                taskContextOptional.get().setIdle(isIdle);
            } else {
                this.add(taskContext);
            }
        }
    }

    private Optional<TaskContext> findTask(TaskContext taskContext) {
        return this.getRunningTasks(taskContext.getMetaInfo().getJobName()).stream().filter(each -> each.equals((Object)taskContext)).findFirst();
    }

    public void remove(String jobName) {
        RUNNING_TASKS.remove(jobName);
        if (!this.isDaemonOrAbsent(jobName)) {
            return;
        }
        this.regCenter.remove(RunningNode.getRunningJobNodePath(jobName));
    }

    public void remove(TaskContext taskContext) {
        this.getRunningTasks(taskContext.getMetaInfo().getJobName()).remove(taskContext);
        if (!this.isDaemonOrAbsent(taskContext.getMetaInfo().getJobName())) {
            return;
        }
        this.regCenter.remove(RunningNode.getRunningTaskNodePath(taskContext.getMetaInfo().toString()));
        String jobRootNode = RunningNode.getRunningJobNodePath(taskContext.getMetaInfo().getJobName());
        if (this.regCenter.isExisted(jobRootNode) && this.regCenter.getChildrenKeys(jobRootNode).isEmpty()) {
            this.regCenter.remove(jobRootNode);
        }
    }

    private boolean isDaemonOrAbsent(String jobName) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfigurationOptional = this.configurationService.load(jobName);
        return !cloudJobConfigurationOptional.isPresent() || CloudJobExecutionType.DAEMON == cloudJobConfigurationOptional.get().getJobExecutionType();
    }

    public boolean isJobRunning(String jobName) {
        return !this.getRunningTasks(jobName).isEmpty();
    }

    public boolean isTaskRunning(TaskContext.MetaInfo metaInfo) {
        for (TaskContext each : this.getRunningTasks(metaInfo.getJobName())) {
            if (!each.getMetaInfo().equals((Object)metaInfo)) continue;
            return true;
        }
        return false;
    }

    public Collection<TaskContext> getRunningTasks(String jobName) {
        CopyOnWriteArraySet taskContexts = new CopyOnWriteArraySet();
        Collection result = RUNNING_TASKS.putIfAbsent(jobName, taskContexts);
        return null == result ? taskContexts : result;
    }

    public Map<String, Set<TaskContext>> getAllRunningTasks() {
        HashMap<String, Set<TaskContext>> result = new HashMap<String, Set<TaskContext>>(RUNNING_TASKS.size(), 1.0f);
        result.putAll(RUNNING_TASKS);
        return result;
    }

    public Set<TaskContext> getAllRunningDaemonTasks() {
        List jobKeys = this.regCenter.getChildrenKeys("/state/running");
        for (String each : jobKeys) {
            if (RUNNING_TASKS.containsKey(each)) continue;
            this.remove(each);
        }
        HashSet result = Sets.newHashSet();
        for (Map.Entry<String, Set<TaskContext>> each : RUNNING_TASKS.entrySet()) {
            if (!this.isDaemonOrAbsent(each.getKey())) continue;
            result.addAll((Collection)each.getValue());
        }
        return result;
    }

    public void addMapping(String taskId, String hostname) {
        TASK_HOSTNAME_MAPPER.putIfAbsent(taskId, hostname);
    }

    public String popMapping(String taskId) {
        return TASK_HOSTNAME_MAPPER.remove(taskId);
    }

    public void clear() {
        RUNNING_TASKS.clear();
        TASK_HOSTNAME_MAPPER.clear();
    }

    @Generated
    public RunningService(CoordinatorRegistryCenter regCenter, CloudJobConfigurationService configurationService) {
        this.regCenter = regCenter;
        this.configurationService = configurationService;
    }

    @Generated
    public static ConcurrentHashMap<String, Set<TaskContext>> getRUNNING_TASKS() {
        return RUNNING_TASKS;
    }
}

