/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.job;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.job.DisableJobNode;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableJobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableJobService.class);
    private final BootstrapEnvironment env = BootstrapEnvironment.getINSTANCE();
    private final CoordinatorRegistryCenter regCenter;

    public DisableJobService(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }

    public void add(String jobName) {
        if (this.regCenter.getNumChildren("/state/disable/job") > this.env.getFrameworkConfiguration().getJobStateQueueSize()) {
            log.warn("Cannot add disable job, caused by read state queue size is larger than {}.", (Object)this.env.getFrameworkConfiguration().getJobStateQueueSize());
            return;
        }
        String disableJobNodePath = DisableJobNode.getDisableJobNodePath(jobName);
        if (!this.regCenter.isExisted(disableJobNodePath)) {
            this.regCenter.persist(disableJobNodePath, jobName);
        }
    }

    public void remove(String jobName) {
        this.regCenter.remove(DisableJobNode.getDisableJobNodePath(jobName));
    }

    public boolean isDisabled(String jobName) {
        return this.regCenter.isExisted(DisableJobNode.getDisableJobNodePath(jobName));
    }
}

