/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.producer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.quartz.JobKey;

final class TransientProducerRepository {
    private final ConcurrentHashMap<JobKey, List<String>> cronTasks = new ConcurrentHashMap(256, 1.0f);

    TransientProducerRepository() {
    }

    synchronized void put(JobKey jobKey, String jobName) {
        this.remove(jobName);
        List<String> taskList = this.cronTasks.get(jobKey);
        if (null == taskList) {
            taskList = new CopyOnWriteArrayList<String>();
            taskList.add(jobName);
            this.cronTasks.put(jobKey, taskList);
            return;
        }
        if (!taskList.contains(jobName)) {
            taskList.add(jobName);
        }
    }

    synchronized void remove(String jobName) {
        for (Map.Entry<JobKey, List<String>> each : this.cronTasks.entrySet()) {
            JobKey jobKey = each.getKey();
            List<String> jobNames = each.getValue();
            jobNames.remove(jobName);
            if (!jobNames.isEmpty()) continue;
            this.cronTasks.remove(jobKey);
        }
    }

    List<String> get(JobKey jobKey) {
        List<String> result = this.cronTasks.get(jobKey);
        return null == result ? Collections.emptyList() : result;
    }

    boolean containsKey(JobKey jobKey) {
        return this.cronTasks.containsKey(jobKey);
    }

    void removeAll() {
        this.cronTasks.clear();
    }
}

