/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.VMAssignmentResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.context.JobContext;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.JobTaskRequest;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LaunchingTasks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LaunchingTasks.class);
    private final Map<String, JobContext> eligibleJobContextsMap;

    public LaunchingTasks(Collection<JobContext> eligibleJobContexts) {
        this.eligibleJobContextsMap = new HashMap<String, JobContext>(eligibleJobContexts.size(), 1.0f);
        for (JobContext each : eligibleJobContexts) {
            this.eligibleJobContextsMap.put(each.getCloudJobConfig().getJobConfig().getJobName(), each);
        }
    }

    List<TaskRequest> getPendingTasks() {
        ArrayList<TaskRequest> result = new ArrayList<TaskRequest>(this.eligibleJobContextsMap.size() * 10);
        for (JobContext each : this.eligibleJobContextsMap.values()) {
            result.addAll(this.createTaskRequests(each));
        }
        return result;
    }

    private Collection<TaskRequest> createTaskRequests(JobContext jobContext) {
        ArrayList<TaskRequest> result = new ArrayList<TaskRequest>(jobContext.getAssignedShardingItems().size());
        for (int each : jobContext.getAssignedShardingItems()) {
            result.add(new JobTaskRequest(new TaskContext(jobContext.getCloudJobConfig().getJobConfig().getJobName(), Collections.singletonList(each), jobContext.getType()), jobContext.getCloudJobConfig()));
        }
        return result;
    }

    Collection<String> getIntegrityViolationJobs(Collection<VMAssignmentResult> vmAssignmentResults) {
        Map<String, Integer> assignedJobShardingTotalCountMap = this.getAssignedJobShardingTotalCountMap(vmAssignmentResults);
        HashSet<String> result = new HashSet<String>(assignedJobShardingTotalCountMap.size(), 1.0f);
        for (Map.Entry<String, Integer> entry : assignedJobShardingTotalCountMap.entrySet()) {
            JobContext jobContext = this.eligibleJobContextsMap.get(entry.getKey());
            if (ExecutionType.FAILOVER == jobContext.getType() || entry.getValue().equals(jobContext.getCloudJobConfig().getJobConfig().getShardingTotalCount())) continue;
            log.warn("Job {} is not assigned at this time, because resources not enough to run all sharding instances.", (Object)entry.getKey());
            result.add(entry.getKey());
        }
        return result;
    }

    private Map<String, Integer> getAssignedJobShardingTotalCountMap(Collection<VMAssignmentResult> vmAssignmentResults) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(this.eligibleJobContextsMap.size(), 1.0f);
        for (VMAssignmentResult vmAssignmentResult : vmAssignmentResults) {
            for (TaskAssignmentResult tasksAssigned : vmAssignmentResult.getTasksAssigned()) {
                String jobName = TaskContext.from((String)tasksAssigned.getTaskId()).getMetaInfo().getJobName();
                if (result.containsKey(jobName)) {
                    result.put(jobName, (Integer)result.get(jobName) + 1);
                    continue;
                }
                result.put(jobName, 1);
            }
        }
        return result;
    }
}

