/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.CloudAppConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.context.JobContext;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.MesosStateService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app.DisableAppService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.job.DisableJobService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.failover.FailoverTaskInfo;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.ready.ReadyService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running.RunningService;
import org.apache.shardingsphere.elasticjob.infra.context.ExecutionType;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacadeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FacadeService.class);
    private final CloudAppConfigurationService appConfigService;
    private final CloudJobConfigurationService jobConfigService;
    private final ReadyService readyService;
    private final RunningService runningService;
    private final FailoverService failoverService;
    private final DisableAppService disableAppService;
    private final DisableJobService disableJobService;
    private final MesosStateService mesosStateService;

    public FacadeService(CoordinatorRegistryCenter regCenter) {
        this.appConfigService = new CloudAppConfigurationService(regCenter);
        this.jobConfigService = new CloudJobConfigurationService(regCenter);
        this.readyService = new ReadyService(regCenter);
        this.runningService = new RunningService(regCenter);
        this.failoverService = new FailoverService(regCenter);
        this.disableAppService = new DisableAppService(regCenter);
        this.disableJobService = new DisableJobService(regCenter);
        this.mesosStateService = new MesosStateService(regCenter);
    }

    public void start() {
        log.info("Elastic Job: Start facade service");
        this.runningService.start();
    }

    public Collection<JobContext> getEligibleJobContext() {
        Collection<JobContext> failoverJobContexts = this.failoverService.getAllEligibleJobContexts();
        Collection<JobContext> readyJobContexts = this.readyService.getAllEligibleJobContexts(failoverJobContexts);
        ArrayList<JobContext> result = new ArrayList<JobContext>(failoverJobContexts.size() + readyJobContexts.size());
        result.addAll(failoverJobContexts);
        result.addAll(readyJobContexts);
        return result;
    }

    public void removeLaunchTasksFromQueue(List<TaskContext> taskContexts) {
        ArrayList<TaskContext> failoverTaskContexts = new ArrayList<TaskContext>(taskContexts.size());
        HashSet<String> readyJobNames = new HashSet<String>(taskContexts.size(), 1.0f);
        for (TaskContext each : taskContexts) {
            switch (each.getType()) {
                case FAILOVER: {
                    failoverTaskContexts.add(each);
                    break;
                }
                case READY: {
                    readyJobNames.add(each.getMetaInfo().getJobName());
                    break;
                }
            }
        }
        this.failoverService.remove(failoverTaskContexts.stream().map(TaskContext::getMetaInfo).collect(Collectors.toList()));
        this.readyService.remove(readyJobNames);
    }

    public void addRunning(TaskContext taskContext) {
        this.runningService.add(taskContext);
    }

    public void updateDaemonStatus(TaskContext taskContext, boolean isIdle) {
        this.runningService.updateIdle(taskContext, isIdle);
    }

    public void removeRunning(TaskContext taskContext) {
        this.runningService.remove(taskContext);
    }

    public void recordFailoverTask(TaskContext taskContext) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfigOptional = this.jobConfigService.load(taskContext.getMetaInfo().getJobName());
        if (!cloudJobConfigOptional.isPresent()) {
            return;
        }
        if (this.isDisable(cloudJobConfigOptional.get())) {
            return;
        }
        CloudJobConfigurationPOJO cloudJobConfig = cloudJobConfigOptional.get();
        if (cloudJobConfig.isFailover() || CloudJobExecutionType.DAEMON == cloudJobConfig.getJobExecutionType()) {
            this.failoverService.add(taskContext);
        }
    }

    private boolean isDisable(CloudJobConfigurationPOJO cloudJobConfig) {
        return this.disableAppService.isDisabled(cloudJobConfig.getAppName()) || this.disableJobService.isDisabled(cloudJobConfig.getJobName());
    }

    public void addTransient(String jobName) {
        this.readyService.addTransient(jobName);
    }

    public Optional<CloudJobConfigurationPOJO> load(String jobName) {
        return this.jobConfigService.load(jobName);
    }

    public Optional<CloudAppConfigurationPOJO> loadAppConfig(String appName) {
        return this.appConfigService.load(appName);
    }

    public Optional<String> getFailoverTaskId(TaskContext.MetaInfo metaInfo) {
        return this.failoverService.getTaskId(metaInfo);
    }

    public void addDaemonJobToReadyQueue(String jobName) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.jobConfigService.load(jobName);
        if (!cloudJobConfig.isPresent()) {
            return;
        }
        if (this.isDisable(cloudJobConfig.get())) {
            return;
        }
        this.readyService.addDaemon(jobName);
    }

    public boolean isRunning(TaskContext taskContext) {
        return ExecutionType.FAILOVER != taskContext.getType() && !this.runningService.getRunningTasks(taskContext.getMetaInfo().getJobName()).isEmpty() || ExecutionType.FAILOVER == taskContext.getType() && this.runningService.isTaskRunning(taskContext.getMetaInfo());
    }

    public void addMapping(String taskId, String hostname) {
        this.runningService.addMapping(taskId, hostname);
    }

    public String popMapping(String taskId) {
        return this.runningService.popMapping(taskId);
    }

    public Map<String, Integer> getAllReadyTasks() {
        return this.readyService.getAllReadyTasks();
    }

    public Map<String, Set<TaskContext>> getAllRunningTasks() {
        return this.runningService.getAllRunningTasks();
    }

    public Map<String, Collection<FailoverTaskInfo>> getAllFailoverTasks() {
        return this.failoverService.getAllFailoverTasks();
    }

    public boolean isJobDisabled(String jobName) {
        Optional<CloudJobConfigurationPOJO> jobConfiguration = this.jobConfigService.load(jobName);
        return !jobConfiguration.isPresent() || this.disableAppService.isDisabled(jobConfiguration.get().getAppName()) || this.disableJobService.isDisabled(jobName);
    }

    public void enableJob(String jobName) {
        this.disableJobService.remove(jobName);
    }

    public void disableJob(String jobName) {
        this.disableJobService.add(jobName);
    }

    public Collection<MesosStateService.ExecutorStateInfo> loadExecutorInfo() throws JsonParseException {
        return this.mesosStateService.executors();
    }

    public void stop() {
        log.info("Elastic Job: Stop facade service");
        this.runningService.clear();
    }
}

