/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler;

import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.ha.SchedulerElectionCandidate;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.base.ElectionCandidate;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperElectionService;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);

    public static void main(String[] args) throws InterruptedException {
        ZookeeperRegistryCenter regCenter = new ZookeeperRegistryCenter(BootstrapEnvironment.getINSTANCE().getZookeeperConfiguration());
        regCenter.init();
        final ZookeeperElectionService electionService = new ZookeeperElectionService(BootstrapEnvironment.getINSTANCE().getFrameworkHostPort(), (CuratorFramework)regCenter.getRawClient(), "/ha/election", (ElectionCandidate)new SchedulerElectionCandidate((CoordinatorRegistryCenter)regCenter));
        electionService.start();
        final CountDownLatch latch = new CountDownLatch(1);
        latch.await();
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown-hook"){

            @Override
            public void run() {
                electionService.stop();
                latch.countDown();
            }
        });
    }

    @Generated
    private Bootstrap() {
    }
}

