/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import org.apache.shardingsphere.elasticjob.restful.NettyRestfulServiceConfiguration;
import org.apache.shardingsphere.elasticjob.restful.pipeline.ContextInitializationInboundHandler;
import org.apache.shardingsphere.elasticjob.restful.pipeline.ExceptionHandling;
import org.apache.shardingsphere.elasticjob.restful.pipeline.FilterChainInboundHandler;
import org.apache.shardingsphere.elasticjob.restful.pipeline.HandleMethodExecutor;
import org.apache.shardingsphere.elasticjob.restful.pipeline.HandlerParameterDecoder;
import org.apache.shardingsphere.elasticjob.restful.pipeline.HttpRequestDispatcher;

public final class RestfulServiceChannelInitializer
extends ChannelInitializer<Channel> {
    private final ContextInitializationInboundHandler contextInitializationInboundHandler = new ContextInitializationInboundHandler();
    private final FilterChainInboundHandler filterChainInboundHandler;
    private final HttpRequestDispatcher httpRequestDispatcher;
    private final HandlerParameterDecoder handlerParameterDecoder;
    private final HandleMethodExecutor handleMethodExecutor;
    private final ExceptionHandling exceptionHandling;

    public RestfulServiceChannelInitializer(NettyRestfulServiceConfiguration configuration) {
        this.filterChainInboundHandler = new FilterChainInboundHandler(configuration.getFilterInstances());
        this.httpRequestDispatcher = new HttpRequestDispatcher(configuration.getControllerInstances(), configuration.isTrailingSlashSensitive());
        this.handlerParameterDecoder = new HandlerParameterDecoder();
        this.handleMethodExecutor = new HandleMethodExecutor();
        this.exceptionHandling = new ExceptionHandling(configuration.getExceptionHandlers());
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
        pipeline.addLast("contextInitialization", (ChannelHandler)this.contextInitializationInboundHandler);
        pipeline.addLast("filterChain", (ChannelHandler)this.filterChainInboundHandler);
        pipeline.addLast("dispatcher", (ChannelHandler)this.httpRequestDispatcher);
        pipeline.addLast("handlerParameterDecoder", (ChannelHandler)this.handlerParameterDecoder);
        pipeline.addLast("handleMethodExecutor", (ChannelHandler)this.handleMethodExecutor);
        pipeline.addLast("exceptionHandling", (ChannelHandler)this.exceptionHandling);
    }
}

