/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.pipeline;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.handler.ExceptionHandleResult;
import org.apache.shardingsphere.elasticjob.restful.handler.ExceptionHandler;
import org.apache.shardingsphere.elasticjob.restful.handler.HandlerNotFoundException;
import org.apache.shardingsphere.elasticjob.restful.handler.impl.DefaultExceptionHandler;
import org.apache.shardingsphere.elasticjob.restful.handler.impl.DefaultHandlerNotFoundExceptionHandler;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializer;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class ExceptionHandling
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandling.class);
    private static final DefaultExceptionHandler DEFAULT_EXCEPTION_HANDLER = new DefaultExceptionHandler();
    private final Map<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> exceptionHandlers = new ConcurrentHashMap<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>>();

    public ExceptionHandling(Map<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> exceptionHandlers) {
        this.initDefaultExceptionHandlers();
        this.addCustomExceptionHandlers(exceptionHandlers);
    }

    private void initDefaultExceptionHandlers() {
        this.exceptionHandlers.put(HandlerNotFoundException.class, new DefaultHandlerNotFoundExceptionHandler());
    }

    private void addCustomExceptionHandlers(Map<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> exceptionHandlers) {
        for (Map.Entry<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> entry : exceptionHandlers.entrySet()) {
            Class<? extends Throwable> exceptionType = entry.getKey();
            ExceptionHandler<? extends Throwable> oldHandler = this.exceptionHandlers.put(exceptionType, entry.getValue());
            if (null == oldHandler) continue;
            log.info("Overriding ExceptionHandler for [{}]", (Object)exceptionType.getName());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ExceptionHandler exceptionHandler = this.searchExceptionHandler(cause);
        ExceptionHandleResult handleResult = exceptionHandler.handleException(cause);
        String mimeType = HttpUtil.getMimeType((CharSequence)handleResult.getContentType()).toString();
        ResponseBodySerializer serializer = ResponseBodySerializerFactory.getResponseBodySerializer(mimeType);
        byte[] body = serializer.serialize(handleResult.getResult());
        FullHttpResponse response = this.createHttpResponse(handleResult.getStatusCode(), handleResult.getContentType(), body);
        ctx.writeAndFlush((Object)response);
    }

    private FullHttpResponse createHttpResponse(int statusCode, String contentType, byte[] body) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)statusCode), Unpooled.copiedBuffer((byte[])body));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        HttpUtil.setContentLength((HttpMessage)response, (long)body.length);
        return response;
    }

    private <T extends Throwable> ExceptionHandler<T> searchExceptionHandler(Throwable cause) {
        Class<?> exceptionType = cause.getClass();
        ExceptionHandler<Throwable> exceptionHandler = this.exceptionHandlers.get(exceptionType);
        if (null == exceptionHandler) {
            for (Map.Entry<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> entry : this.exceptionHandlers.entrySet()) {
                Class<? extends Throwable> clazz = entry.getKey();
                ExceptionHandler<? extends Throwable> handler = entry.getValue();
                if (!clazz.isAssignableFrom(exceptionType)) continue;
                exceptionHandler = handler;
                break;
            }
        }
        if (null == exceptionHandler) {
            exceptionHandler = DEFAULT_EXCEPTION_HANDLER;
        }
        return exceptionHandler;
    }
}

