/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.schedule;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public final class JobScheduleController {
    private final Scheduler scheduler;
    private final JobDetail jobDetail;
    private final String triggerIdentity;

    public void scheduleJob(String cron) {
        try {
            if (!this.scheduler.checkExists(this.jobDetail.getKey())) {
                this.scheduler.scheduleJob(this.jobDetail, this.createCronTrigger(cron));
            }
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void rescheduleJob(String cron) {
        try {
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)this.triggerIdentity));
            if (!this.scheduler.isShutdown() && null != trigger && !cron.equals(trigger.getCronExpression())) {
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)this.triggerIdentity), this.createCronTrigger(cron));
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void rescheduleJob() {
        try {
            SimpleTrigger trigger = (SimpleTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)this.triggerIdentity));
            if (!this.scheduler.isShutdown() && null != trigger) {
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)this.triggerIdentity), this.createOneOffTrigger());
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private Trigger createCronTrigger(String cron) {
        return TriggerBuilder.newTrigger().withIdentity(this.triggerIdentity).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing()).build();
    }

    public synchronized boolean isPaused() {
        try {
            return !this.scheduler.isShutdown() && Trigger.TriggerState.PAUSED == this.scheduler.getTriggerState(new TriggerKey(this.triggerIdentity));
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void pauseJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.pauseAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void resumeJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.resumeAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public synchronized void triggerJob() {
        try {
            if (this.scheduler.isShutdown()) {
                return;
            }
            if (!this.scheduler.checkExists(this.jobDetail.getKey())) {
                this.scheduler.scheduleJob(this.jobDetail, this.createOneOffTrigger());
            } else {
                this.scheduler.triggerJob(this.jobDetail.getKey());
            }
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private Trigger createOneOffTrigger() {
        return TriggerBuilder.newTrigger().withIdentity(this.triggerIdentity).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).build();
    }

    public synchronized void shutdown() {
        this.shutdown(false);
    }

    public synchronized void shutdown(boolean isCleanShutdown) {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown(isCleanShutdown);
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    @Generated
    public JobScheduleController(Scheduler scheduler, JobDetail jobDetail, String triggerIdentity) {
        this.scheduler = scheduler;
        this.jobDetail = jobDetail;
        this.triggerIdentity = triggerIdentity;
    }
}

