/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.instance;

import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceNode;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceOperation;
import org.apache.shardingsphere.elasticjob.lite.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractJobListener;
import org.apache.shardingsphere.elasticjob.lite.internal.listener.AbstractListenerManager;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class TriggerListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final InstanceNode instanceNode;
    private final InstanceService instanceService;

    public TriggerListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.instanceNode = new InstanceNode(jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobTriggerStatusJobListener());
    }

    class JobTriggerStatusJobListener
    extends AbstractJobListener {
        JobTriggerStatusJobListener() {
        }

        @Override
        protected void dataChanged(String path, CuratorCacheListener.Type eventType, String data) {
            if (!InstanceOperation.TRIGGER.name().equals(data) || !TriggerListenerManager.this.instanceNode.isLocalInstancePath(path) || CuratorCacheListener.Type.NODE_CHANGED != eventType) {
                return;
            }
            TriggerListenerManager.this.instanceService.clearTriggerFlag();
            if (!JobRegistry.getInstance().isShutdown(TriggerListenerManager.this.jobName) && !JobRegistry.getInstance().isJobRunning(TriggerListenerManager.this.jobName)) {
                JobRegistry.getInstance().getJobScheduleController(TriggerListenerManager.this.jobName).triggerJob();
            }
        }
    }
}

