/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.error.handler.dingtalk;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.shardingsphere.elasticjob.error.handler.JobErrorHandler;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DingtalkJobErrorHandler
implements JobErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingtalkJobErrorHandler.class);
    private final CloseableHttpClient httpclient = HttpClients.createDefault();
    private String webhook;
    private String keyword;
    private String secret;
    private int connectTimeoutMilliseconds;
    private int readTimeoutMilliseconds;

    public void init(Properties props) {
        this.webhook = props.getProperty("dingtalk.webhook");
        this.keyword = props.getProperty("dingtalk.keyword");
        this.secret = props.getProperty("dingtalk.secret");
        this.connectTimeoutMilliseconds = Integer.parseInt(props.getProperty("dingtalk.connectTimeoutMilliseconds", "3000"));
        this.readTimeoutMilliseconds = Integer.parseInt(props.getProperty("dingtalk.readTimeoutMilliseconds", "5000"));
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("DingtalkJobErrorHandler Shutdown-Hook"){

            @Override
            public void run() {
                log.info("Shutting down HTTP client...");
                DingtalkJobErrorHandler.this.httpclient.close();
            }
        });
    }

    public void handleException(String jobName, Throwable cause) {
        HttpPost httpPost = this.createHTTPPostMethod(jobName, cause);
        try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpPost);){
            int status = response.getStatusLine().getStatusCode();
            if (200 == status) {
                JsonObject responseMessage = (JsonObject)GsonFactory.getGson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
                if (!"0".equals(responseMessage.get("errcode").getAsString())) {
                    log.error("An exception has occurred in Job '{}' but failed to send dingtalk because of: {}", new Object[]{jobName, responseMessage.get("errmsg").getAsString(), cause});
                } else {
                    log.info("An exception has occurred in Job '{}', an dingtalk message been sent successful.", (Object)jobName, (Object)cause);
                }
            } else {
                log.error("An exception has occurred in Job '{}' but failed to send dingtalk because of: unexpected http response status: {}", new Object[]{jobName, status, cause});
            }
        }
        catch (IOException ex) {
            cause.addSuppressed(ex);
            log.error("An exception has occurred in Job '{}', but failed to send dingtalk because of", (Object)jobName, (Object)cause);
        }
    }

    private HttpPost createHTTPPostMethod(String jobName, Throwable cause) {
        HttpPost result = new HttpPost(this.getURL());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeoutMilliseconds).setSocketTimeout(this.readTimeoutMilliseconds).build();
        result.setConfig(requestConfig);
        StringEntity entity = new StringEntity(this.getJsonParameter(this.getErrorMessage(jobName, cause)), StandardCharsets.UTF_8);
        entity.setContentEncoding(StandardCharsets.UTF_8.name());
        entity.setContentType("application/json");
        result.setEntity((HttpEntity)entity);
        return result;
    }

    private String getURL() {
        return Strings.isNullOrEmpty((String)this.secret) ? this.webhook : this.getSignedURL();
    }

    private String getSignedURL() {
        long timestamp = System.currentTimeMillis();
        return String.format("%s&timestamp=%s&sign=%s", this.webhook, timestamp, this.generateSignature(timestamp));
    }

    private String generateSignature(long timestamp) {
        String algorithmName = "HmacSHA256";
        Mac mac = Mac.getInstance(algorithmName);
        mac.init(new SecretKeySpec(this.secret.getBytes(StandardCharsets.UTF_8), algorithmName));
        byte[] signData = mac.doFinal((timestamp + "\n" + this.secret).getBytes(StandardCharsets.UTF_8));
        return URLEncoder.encode(new String(Base64.getEncoder().encode(signData)), StandardCharsets.UTF_8.name());
    }

    private String getJsonParameter(String message) {
        return GsonFactory.getGson().toJson((Object)ImmutableMap.of((Object)"msgtype", (Object)"text", (Object)"text", Collections.singletonMap("content", message)));
    }

    private String getErrorMessage(String jobName, Throwable cause) {
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter((Writer)writer, true));
        String result = String.format("Job '%s' exception occur in job processing, caused by %s", jobName, writer.toString());
        if (!Strings.isNullOrEmpty((String)this.keyword)) {
            result = this.keyword.concat(result);
        }
        return result;
    }

    public String getType() {
        return "DINGTALK";
    }
}

