/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.spring.namespace.job.parser;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class JobBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory;
        if (Strings.isNullOrEmpty((String)element.getAttribute("cron"))) {
            factory = BeanDefinitionBuilder.rootBeanDefinition(OneOffJobBootstrap.class);
        } else {
            factory = BeanDefinitionBuilder.rootBeanDefinition(ScheduleJobBootstrap.class);
            factory.setInitMethodName("schedule");
        }
        factory.addConstructorArgReference(element.getAttribute("registry-center-ref"));
        String jobType = element.getAttribute("job-type");
        if (!Strings.isNullOrEmpty((String)jobType)) {
            factory.addConstructorArgValue((Object)jobType);
        } else {
            factory.addConstructorArgReference(element.getAttribute("job-ref"));
        }
        factory.addConstructorArgValue((Object)this.createJobConfigurationBeanDefinition(element, parserContext));
        return factory.getBeanDefinition();
    }

    private BeanDefinition createJobConfigurationBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(JobConfiguration.class);
        result.addConstructorArgValue((Object)element.getAttribute("id"));
        result.addConstructorArgValue((Object)element.getAttribute("cron"));
        result.addConstructorArgValue((Object)element.getAttribute("sharding-total-count"));
        result.addConstructorArgValue((Object)element.getAttribute("sharding-item-parameters"));
        result.addConstructorArgValue((Object)element.getAttribute("job-parameter"));
        result.addConstructorArgValue((Object)element.getAttribute("monitor-execution"));
        result.addConstructorArgValue((Object)element.getAttribute("failover"));
        result.addConstructorArgValue((Object)element.getAttribute("misfire"));
        result.addConstructorArgValue((Object)element.getAttribute("max-time-diff-seconds"));
        result.addConstructorArgValue((Object)element.getAttribute("reconcile-interval-minutes"));
        result.addConstructorArgValue((Object)element.getAttribute("job-sharding-strategy-type"));
        result.addConstructorArgValue((Object)element.getAttribute("job-executor-service-handler-type"));
        result.addConstructorArgValue((Object)element.getAttribute("job-error-handler-type"));
        if (StringUtils.isEmpty((Object)element.getAttribute("job-listener-types").trim())) {
            result.addConstructorArgValue(Collections.emptyList());
        } else {
            result.addConstructorArgValue(Arrays.asList(element.getAttribute("job-listener-types").split(",")));
        }
        result.addConstructorArgValue(this.parseExtraConfigs(new String[]{"tracing-ref"}, element, parserContext));
        result.addConstructorArgValue((Object)element.getAttribute("description"));
        result.addConstructorArgValue((Object)this.parsePropsElement(element, parserContext));
        result.addConstructorArgValue((Object)element.getAttribute("disabled"));
        result.addConstructorArgValue((Object)element.getAttribute("overwrite"));
        return result.getBeanDefinition();
    }

    private Collection<BeanDefinition> parseExtraConfigs(String[] extraConfigRefs, Element element, ParserContext parserContext) {
        ManagedList result = new ManagedList(extraConfigRefs.length);
        for (String each : extraConfigRefs) {
            String attribute = element.getAttribute(each);
            if (Strings.isNullOrEmpty((String)attribute)) continue;
            result.add(parserContext.getRegistry().getBeanDefinition(attribute));
        }
        return result;
    }

    private Properties parsePropsElement(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

