/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.RestfulController;
import org.apache.shardingsphere.elasticjob.restful.annotation.ContextPath;
import org.apache.shardingsphere.elasticjob.restful.annotation.Mapping;
import org.apache.shardingsphere.elasticjob.restful.handler.HandleContext;
import org.apache.shardingsphere.elasticjob.restful.handler.Handler;
import org.apache.shardingsphere.elasticjob.restful.handler.HandlerMappingRegistry;
import org.apache.shardingsphere.elasticjob.restful.handler.HandlerNotFoundException;
import org.apache.shardingsphere.elasticjob.restful.mapping.MappingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class HttpRequestDispatcher
extends ChannelInboundHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestDispatcher.class);
    private static final String TRAILING_SLASH = "/";
    private final HandlerMappingRegistry mappingRegistry = new HandlerMappingRegistry();
    private final boolean trailingSlashSensitive;

    public HttpRequestDispatcher(List<RestfulController> restfulControllers, boolean trailingSlashSensitive) {
        this.trailingSlashSensitive = trailingSlashSensitive;
        this.initMappingRegistry(restfulControllers);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        MappingContext<Handler> mappingContext;
        log.debug("{}", msg);
        FullHttpRequest request = (FullHttpRequest)msg;
        if (!this.trailingSlashSensitive) {
            request.setUri(this.appendTrailingSlashIfAbsent(request.uri()));
        }
        if (null == (mappingContext = this.mappingRegistry.getMappingContext((HttpRequest)request))) {
            throw new HandlerNotFoundException(request.uri());
        }
        HandleContext<Handler> handleContext = new HandleContext<Handler>(request, mappingContext);
        ctx.fireChannelRead(handleContext);
    }

    private void initMappingRegistry(List<RestfulController> restfulControllers) {
        for (RestfulController restfulController : restfulControllers) {
            Class<?> controllerClass = restfulController.getClass();
            String contextPath = Optional.ofNullable(controllerClass.getAnnotation(ContextPath.class)).map(ContextPath::value).orElse("");
            for (Method method : controllerClass.getMethods()) {
                Mapping mapping = method.getAnnotation(Mapping.class);
                if (null == mapping) continue;
                HttpMethod httpMethod = HttpMethod.valueOf((String)mapping.method());
                String path = mapping.path();
                String fullPathPattern = this.resolveFullPath(contextPath, path);
                if (!this.trailingSlashSensitive) {
                    fullPathPattern = this.appendTrailingSlashIfAbsent(fullPathPattern);
                }
                this.mappingRegistry.addMapping(httpMethod, fullPathPattern, new Handler(restfulController, method));
            }
        }
    }

    private String resolveFullPath(String contextPath, String pattern) {
        return Optional.ofNullable(contextPath).orElse("") + pattern;
    }

    private String appendTrailingSlashIfAbsent(String uri) {
        String[] split = uri.split("\\?");
        if (1 == split.length) {
            return uri.endsWith(TRAILING_SLASH) ? uri : uri + TRAILING_SLASH;
        }
        String path = split[0];
        return path.endsWith(TRAILING_SLASH) ? uri : path + TRAILING_SLASH + "?" + split[1];
    }
}

