/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.pipeline;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.lang.reflect.InvocationTargetException;
import org.apache.shardingsphere.elasticjob.restful.handler.HandleContext;
import org.apache.shardingsphere.elasticjob.restful.handler.Handler;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializer;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializerFactory;

@ChannelHandler.Sharable
public final class HandleMethodExecutor
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpResponse response;
        Object[] args;
        HandleContext handleContext = (HandleContext)msg;
        Handler handler = (Handler)handleContext.getMappingContext().payload();
        Object handleResult = handler.execute(args = handleContext.getArgs());
        if (null != handleResult) {
            String mimeType = HttpUtil.getMimeType((CharSequence)handler.getProducing()).toString();
            ResponseBodySerializer serializer = ResponseBodySerializerFactory.getResponseBodySerializer(mimeType);
            byte[] bodyBytes = serializer.serialize(handleResult);
            response = this.createHttpResponse(handler.getProducing(), bodyBytes, handler.getHttpStatusCode());
        } else {
            response = this.createHttpResponse(handler.getProducing(), new byte[0], handler.getHttpStatusCode());
        }
        ctx.writeAndFlush((Object)response);
    }

    private FullHttpResponse createHttpResponse(String producingContentType, byte[] bodyBytes, int statusCode) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)statusCode);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, Unpooled.wrappedBuffer((byte[])bodyBytes));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)producingContentType);
        HttpUtil.setContentLength((HttpMessage)response, (long)bodyBytes.length);
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
        return response;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            ctx.fireExceptionCaught(cause.getCause());
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }
}

