/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.handler;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.elasticjob.restful.handler.Handler;
import org.apache.shardingsphere.elasticjob.restful.mapping.MappingContext;
import org.apache.shardingsphere.elasticjob.restful.mapping.RegexUrlPatternMap;
import org.apache.shardingsphere.elasticjob.restful.mapping.UrlPatternMap;

public final class HandlerMappingRegistry {
    private final Map<HttpMethod, UrlPatternMap<Handler>> mappings = new HashMap<HttpMethod, UrlPatternMap<Handler>>();

    public MappingContext<Handler> getMappingContext(HttpRequest httpRequest) {
        UrlPatternMap<Handler> urlPatternMap = this.mappings.get(httpRequest.method());
        String uriWithoutQuery = httpRequest.uri().split("\\?")[0];
        return Optional.ofNullable(urlPatternMap.match(uriWithoutQuery)).orElse(null);
    }

    public void addMapping(HttpMethod method, String pathPattern, Handler handler) {
        this.mappings.computeIfAbsent(method, httpMethod -> new RegexUrlPatternMap());
        UrlPatternMap<Handler> urlPatternMap = this.mappings.get(method);
        urlPatternMap.put(pathPattern, handler);
    }
}

