/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.TaskResultMetaData;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.AbstractStatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.util.StatisticTimeUtils;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.rdb.StatisticRdbRepository;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskResultStatistics;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskResultStatisticJob
extends AbstractStatisticJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskResultStatisticJob.class);
    private StatisticInterval statisticInterval;
    private TaskResultMetaData sharedData;
    private StatisticRdbRepository repository;

    @Override
    public JobDetail buildJobDetail() {
        JobDetail result = JobBuilder.newJob(this.getClass()).withIdentity(this.getJobName() + "_" + this.statisticInterval).build();
        result.getJobDataMap().put("statisticUnit", (Object)this.statisticInterval);
        return result;
    }

    @Override
    public Trigger buildTrigger() {
        return TriggerBuilder.newTrigger().withIdentity(this.getTriggerName() + "_" + this.statisticInterval).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.statisticInterval.getCron()).withMisfireHandlingInstructionDoNothing()).build();
    }

    @Override
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("statisticInterval", this.statisticInterval);
        result.put("sharedData", this.sharedData);
        result.put("repository", this.repository);
        return result;
    }

    public void execute(JobExecutionContext context) {
        Optional latestOne = this.repository.findLatestTaskResultStatistics(this.statisticInterval);
        latestOne.ifPresent(this::fillBlankIfNeeded);
        TaskResultStatistics taskResultStatistics = new TaskResultStatistics(this.sharedData.getSuccessCount(), this.sharedData.getFailedCount(), this.statisticInterval, StatisticTimeUtils.getCurrentStatisticTime(this.statisticInterval));
        log.debug("Add taskResultStatistics, statisticInterval is:{}, successCount is:{}, failedCount is:{}", new Object[]{this.statisticInterval, this.sharedData.getSuccessCount(), this.sharedData.getFailedCount()});
        this.repository.add(taskResultStatistics);
        this.sharedData.reset();
    }

    private void fillBlankIfNeeded(TaskResultStatistics latestOne) {
        List<Date> blankDateRange = this.findBlankStatisticTimes(latestOne.getStatisticsTime(), this.statisticInterval);
        if (!blankDateRange.isEmpty()) {
            log.debug("Fill blank range of taskResultStatistics, range is:{}", blankDateRange);
        }
        for (Date each : blankDateRange) {
            this.repository.add(new TaskResultStatistics(latestOne.getSuccessCount(), latestOne.getFailedCount(), this.statisticInterval, each));
        }
    }

    @Generated
    public void setStatisticInterval(StatisticInterval statisticInterval) {
        this.statisticInterval = statisticInterval;
    }

    @Generated
    public void setSharedData(TaskResultMetaData sharedData) {
        this.sharedData = sharedData;
    }

    @Generated
    public void setRepository(StatisticRdbRepository repository) {
        this.repository = repository;
    }

    @Generated
    public TaskResultStatisticJob() {
    }

    @Generated
    public TaskResultStatisticJob(StatisticInterval statisticInterval, TaskResultMetaData sharedData, StatisticRdbRepository repository) {
        this.statisticInterval = statisticInterval;
        this.sharedData = sharedData;
        this.repository = repository;
    }
}

