/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.producer;

import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.mesos.Protos;
import org.apache.mesos.SchedulerDriver;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.CloudAppConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.pojo.CloudAppConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.exception.AppConfigurationException;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.TransientProducerScheduler;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app.DisableAppService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.job.DisableJobService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.ready.ReadyService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.running.RunningService;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.infra.exception.JobConfigurationException;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProducerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerManager.class);
    private final CloudAppConfigurationService appConfigService;
    private final CloudJobConfigurationService configService;
    private final ReadyService readyService;
    private final RunningService runningService;
    private final DisableAppService disableAppService;
    private final DisableJobService disableJobService;
    private final TransientProducerScheduler transientProducerScheduler;
    private final SchedulerDriver schedulerDriver;

    public ProducerManager(SchedulerDriver schedulerDriver, CoordinatorRegistryCenter regCenter) {
        this.schedulerDriver = schedulerDriver;
        this.appConfigService = new CloudAppConfigurationService(regCenter);
        this.configService = new CloudJobConfigurationService(regCenter);
        this.readyService = new ReadyService(regCenter);
        this.runningService = new RunningService(regCenter);
        this.disableAppService = new DisableAppService(regCenter);
        this.disableJobService = new DisableJobService(regCenter);
        this.transientProducerScheduler = new TransientProducerScheduler(this.readyService);
    }

    public void startup() {
        log.info("Start producer manager");
        this.transientProducerScheduler.start();
        for (CloudJobConfigurationPOJO each : this.configService.loadAll()) {
            this.schedule(each);
        }
    }

    public void register(CloudJobConfigurationPOJO cloudJobConfig) {
        if (this.disableJobService.isDisabled(cloudJobConfig.getJobName())) {
            throw new JobConfigurationException("Job '%s' has been disable.", new Object[]{cloudJobConfig.getJobName()});
        }
        Optional<CloudAppConfigurationPOJO> appConfigFromZk = this.appConfigService.load(cloudJobConfig.getAppName());
        if (!appConfigFromZk.isPresent()) {
            throw new AppConfigurationException("Register app '%s' firstly.", cloudJobConfig.getAppName());
        }
        Optional<CloudJobConfigurationPOJO> jobConfigFromZk = this.configService.load(cloudJobConfig.getJobName());
        if (jobConfigFromZk.isPresent()) {
            throw new JobConfigurationException("Job '%s' already existed.", new Object[]{cloudJobConfig.getJobName()});
        }
        this.configService.add(cloudJobConfig);
        this.schedule(cloudJobConfig);
    }

    public void update(CloudJobConfigurationPOJO cloudJobConfig) {
        Optional<CloudJobConfigurationPOJO> jobConfigFromZk = this.configService.load(cloudJobConfig.getJobName());
        if (!jobConfigFromZk.isPresent()) {
            throw new JobConfigurationException("Cannot found job '%s', please register first.", new Object[]{cloudJobConfig.getJobName()});
        }
        this.configService.update(cloudJobConfig);
        this.reschedule(cloudJobConfig.getJobName());
    }

    public void deregister(String jobName) {
        Optional<CloudJobConfigurationPOJO> jobConfig = this.configService.load(jobName);
        if (jobConfig.isPresent()) {
            this.disableJobService.remove(jobName);
            this.configService.remove(jobName);
        }
        this.unschedule(jobName);
    }

    public void schedule(CloudJobConfigurationPOJO cloudJobConfig) {
        if (this.disableAppService.isDisabled(cloudJobConfig.getAppName()) || this.disableJobService.isDisabled(cloudJobConfig.getJobName())) {
            return;
        }
        if (CloudJobExecutionType.TRANSIENT == cloudJobConfig.getJobExecutionType()) {
            this.transientProducerScheduler.register(cloudJobConfig);
        } else if (CloudJobExecutionType.DAEMON == cloudJobConfig.getJobExecutionType()) {
            this.readyService.addDaemon(cloudJobConfig.getJobName());
        }
    }

    public void unschedule(String jobName) {
        for (TaskContext each : this.runningService.getRunningTasks(jobName)) {
            this.schedulerDriver.killTask(Protos.TaskID.newBuilder().setValue(each.getId()).build());
        }
        this.runningService.remove(jobName);
        this.readyService.remove(Collections.singletonList(jobName));
        Optional<CloudJobConfigurationPOJO> jobConfig = this.configService.load(jobName);
        jobConfig.ifPresent(this.transientProducerScheduler::deregister);
    }

    public void reschedule(String jobName) {
        this.unschedule(jobName);
        Optional<CloudJobConfigurationPOJO> jobConfig = this.configService.load(jobName);
        jobConfig.ifPresent(this::schedule);
    }

    public void sendFrameworkMessage(Protos.ExecutorID executorId, Protos.SlaveID slaveId, byte[] data) {
        this.schedulerDriver.sendFrameworkMessage(executorId, slaveId, data);
    }

    public void shutdown() {
        log.info("Stop producer manager");
        this.transientProducerScheduler.shutdown();
    }
}

