/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console;

import org.apache.shardingsphere.elasticjob.cloud.console.config.advice.ConsoleExceptionHandler;
import org.apache.shardingsphere.elasticjob.cloud.console.controller.CloudAppController;
import org.apache.shardingsphere.elasticjob.cloud.console.controller.CloudJobController;
import org.apache.shardingsphere.elasticjob.cloud.console.controller.CloudOperationController;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.RestfulServerConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.ReconcileService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.restful.NettyRestfulService;
import org.apache.shardingsphere.elasticjob.restful.NettyRestfulServiceConfiguration;
import org.apache.shardingsphere.elasticjob.restful.RestfulController;
import org.apache.shardingsphere.elasticjob.restful.RestfulService;
import org.apache.shardingsphere.elasticjob.restful.handler.ExceptionHandler;

public class ConsoleBootstrap {
    private final RestfulService restfulService;

    public ConsoleBootstrap(CoordinatorRegistryCenter regCenter, RestfulServerConfiguration config, ProducerManager producerManager, ReconcileService reconcileService) {
        CloudJobController.init(regCenter, producerManager);
        CloudAppController.init(regCenter, producerManager);
        CloudOperationController.init(regCenter, reconcileService);
        NettyRestfulServiceConfiguration restfulServiceConfiguration = new NettyRestfulServiceConfiguration(config.getPort());
        restfulServiceConfiguration.addControllerInstance(new RestfulController[]{new CloudJobController(), new CloudAppController(), new CloudOperationController()});
        restfulServiceConfiguration.addExceptionHandler(Exception.class, (ExceptionHandler)new ConsoleExceptionHandler());
        this.restfulService = new NettyRestfulService(restfulServiceConfiguration);
    }

    public void start() {
        this.restfulService.startup();
    }

    public void stop() {
        this.restfulService.shutdown();
    }
}

