/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.queues.InternalTaskQueue;
import com.netflix.fenzo.queues.InvalidTierNumberException;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.TaskQueueMultiException;
import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.queues.tiered.Tier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TieredQueue
implements InternalTaskQueue {
    private static final Logger logger = LoggerFactory.getLogger(TieredQueue.class);
    private final List<Tier> tiers;
    private Iterator<Tier> iterator = null;
    private Tier currTier = null;
    private final BlockingQueue<QueuableTask> tasksToQueue;
    private final BlockingQueue<QAttributes.TaskIdAttributesTuple> taskIdsToRemove;

    public TieredQueue(int numTiers) {
        this.tiers = new ArrayList<Tier>(numTiers);
        for (int i = 0; i < numTiers; ++i) {
            this.tiers.add(new Tier(i));
        }
        this.tasksToQueue = new LinkedBlockingQueue<QueuableTask>();
        this.taskIdsToRemove = new LinkedBlockingQueue<QAttributes.TaskIdAttributesTuple>();
    }

    @Override
    public void queueTask(QueuableTask task) {
        this.tasksToQueue.offer(task);
    }

    private void addInternal(QueuableTask task) throws TaskQueueException {
        int tierNumber = task.getQAttributes().getTierNumber();
        if (tierNumber >= this.tiers.size()) {
            throw new InvalidTierNumberException(tierNumber, this.tiers.size());
        }
        this.tiers.get(tierNumber).queueTask(task);
    }

    private void addRunningInternal(QueuableTask t) throws TaskQueueException {
        int number = t.getQAttributes().getTierNumber();
        if (number >= this.tiers.size()) {
            throw new InvalidTierNumberException(number, this.tiers.size());
        }
        this.tiers.get(number).launchTask(t);
    }

    @Override
    public void remove(String taskId, QAttributes qAttributes) {
        this.taskIdsToRemove.offer(new QAttributes.TaskIdAttributesTuple(taskId, qAttributes));
    }

    private boolean removeInternalById(String id, QAttributes qAttributes) throws TaskQueueException {
        Tier tierBuckets = this.tiers.get(qAttributes.getTierNumber());
        return tierBuckets != null && tierBuckets.removeTask(id, qAttributes) != null;
    }

    @Override
    public QueuableTask next() throws TaskQueueException {
        QueuableTask task;
        if (this.iterator == null) {
            this.iterator = this.tiers.iterator();
            this.currTier = null;
        }
        if (this.currTier != null) {
            task = this.currTier.nextTaskToLaunch();
            if (task != null) {
                return task;
            }
            this.currTier = null;
        }
        while (this.currTier == null && this.iterator.hasNext()) {
            if (!this.iterator.hasNext()) continue;
            this.currTier = this.iterator.next();
            task = this.currTier.nextTaskToLaunch();
            if (task != null) {
                return task;
            }
            this.currTier = null;
        }
        return null;
    }

    @Override
    public boolean reset() throws TaskQueueMultiException {
        this.iterator = null;
        boolean queueChanged = false;
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        if (this.tasksToQueue.peek() != null) {
            LinkedList toQueue = new LinkedList();
            this.tasksToQueue.drainTo(toQueue);
            if (!toQueue.isEmpty()) {
                for (QueuableTask t : toQueue) {
                    try {
                        this.addInternal(t);
                        queueChanged = true;
                    }
                    catch (TaskQueueException e) {
                        exceptions.add(e);
                    }
                }
            }
        }
        if (this.taskIdsToRemove.peek() != null) {
            ArrayList taskIdTuples = new ArrayList();
            this.taskIdsToRemove.drainTo(taskIdTuples);
            if (!taskIdTuples.isEmpty()) {
                for (QAttributes.TaskIdAttributesTuple tuple : taskIdTuples) {
                    try {
                        if (!this.removeInternalById(tuple.getId(), tuple.getqAttributes())) {
                            logger.debug("Task with id " + tuple.getId() + " not found to remove");
                            continue;
                        }
                        queueChanged = true;
                    }
                    catch (TaskQueueException e) {
                        exceptions.add(e);
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            throw new TaskQueueMultiException(exceptions);
        }
        return queueChanged;
    }

    @Override
    public UsageTrackedQueue getUsageTracker() {
        return new UsageTrackedQueue(){

            @Override
            public void queueTask(QueuableTask t) throws TaskQueueException {
                ((Tier)TieredQueue.this.tiers.get(t.getQAttributes().getTierNumber())).queueTask(t);
            }

            @Override
            public QueuableTask nextTaskToLaunch() {
                return null;
            }

            @Override
            public void assignTask(QueuableTask t) throws TaskQueueException {
                ((Tier)TieredQueue.this.tiers.get(t.getQAttributes().getTierNumber())).assignTask(t);
            }

            @Override
            public boolean launchTask(QueuableTask t) throws TaskQueueException {
                return ((Tier)TieredQueue.this.tiers.get(t.getQAttributes().getTierNumber())).launchTask(t);
            }

            @Override
            public QueuableTask removeTask(String id, QAttributes qAttributes) throws TaskQueueException {
                return ((Tier)TieredQueue.this.tiers.get(qAttributes.getTierNumber())).removeTask(id, qAttributes);
            }

            @Override
            public double getDominantUsageShare(UsageTrackedQueue.ResUsage parentUsage) {
                return 0.0;
            }

            @Override
            public void reset() {
                for (Tier tb : TieredQueue.this.tiers) {
                    tb.reset();
                }
            }

            @Override
            public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() {
        HashMap<TaskQueue.TaskState, Collection<QueuableTask>> result = new HashMap<TaskQueue.TaskState, Collection<QueuableTask>>();
        for (Tier tb : this.tiers) {
            try {
                Map<TaskQueue.TaskState, Collection<QueuableTask>> allTasks = tb.getAllTasks();
                if (allTasks.isEmpty()) continue;
                for (TaskQueue.TaskState s : TaskQueue.TaskState.values()) {
                    Collection<QueuableTask> t = allTasks.get((Object)s);
                    if (t == null || t.isEmpty()) continue;
                    LinkedList<QueuableTask> st = (LinkedList<QueuableTask>)result.get((Object)s);
                    if (st == null) {
                        st = new LinkedList<QueuableTask>();
                        result.put(s, st);
                    }
                    st.addAll(t);
                }
            }
            catch (TaskQueueException e) {
                logger.error("Unexpected: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

