/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.executor.prod;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.mesos.Executor;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.executor.prod.DaemonTaskScheduler;
import org.apache.shardingsphere.elasticjob.cloud.facade.CloudJobFacade;
import org.apache.shardingsphere.elasticjob.executor.ElasticJobExecutor;
import org.apache.shardingsphere.elasticjob.executor.JobFacade;
import org.apache.shardingsphere.elasticjob.infra.concurrent.ElasticJobExecutorService;
import org.apache.shardingsphere.elasticjob.infra.exception.ExceptionUtils;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.tracing.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskExecutor
implements Executor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutor.class);
    private final ElasticJob elasticJob;
    private final String elasticJobType;
    private final ExecutorService executorService = new ElasticJobExecutorService("cloud-task-executor", Runtime.getRuntime().availableProcessors() * 100).createExecutorService();
    private volatile ElasticJobExecutor jobExecutor;
    private volatile JobTracingEventBus jobTracingEventBus = new JobTracingEventBus();

    public TaskExecutor(ElasticJob elasticJob) {
        this(elasticJob, null);
    }

    public TaskExecutor(String elasticJobType) {
        this(null, elasticJobType);
    }

    public void registered(ExecutorDriver executorDriver, Protos.ExecutorInfo executorInfo, Protos.FrameworkInfo frameworkInfo, Protos.SlaveInfo slaveInfo) {
        if (!executorInfo.getData().isEmpty()) {
            Map data = (Map)SerializationUtils.deserialize((byte[])executorInfo.getData().toByteArray());
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName((String)data.get("event_trace_rdb_driver"));
            dataSource.setUrl((String)data.get("event_trace_rdb_url"));
            dataSource.setPassword((String)data.get("event_trace_rdb_password"));
            dataSource.setUsername((String)data.get("event_trace_rdb_username"));
            this.jobTracingEventBus = new JobTracingEventBus(new TracingConfiguration("RDB", (Object)dataSource));
        }
    }

    public void reregistered(ExecutorDriver executorDriver, Protos.SlaveInfo slaveInfo) {
    }

    public void disconnected(ExecutorDriver executorDriver) {
    }

    public void launchTask(ExecutorDriver executorDriver, Protos.TaskInfo taskInfo) {
        this.executorService.submit(new TaskThread(executorDriver, taskInfo));
    }

    public void killTask(ExecutorDriver executorDriver, Protos.TaskID taskID) {
        executorDriver.sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(taskID).setState(Protos.TaskState.TASK_KILLED).build());
        DaemonTaskScheduler.shutdown(taskID);
    }

    public void frameworkMessage(ExecutorDriver executorDriver, byte[] bytes) {
        if (null != bytes && "STOP".equals(new String(bytes))) {
            log.error("call frameworkMessage executor stopped.");
            executorDriver.stop();
        }
    }

    public void shutdown(ExecutorDriver executorDriver) {
    }

    public void error(ExecutorDriver executorDriver, String message) {
        log.error("call executor error, message is: {}", (Object)message);
    }

    @Generated
    private TaskExecutor(ElasticJob elasticJob, String elasticJobType) {
        this.elasticJob = elasticJob;
        this.elasticJobType = elasticJobType;
    }

    class TaskThread
    implements Runnable {
        private final ExecutorDriver executorDriver;
        private final Protos.TaskInfo taskInfo;

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(TaskThread.class.getClassLoader());
            this.executorDriver.sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(this.taskInfo.getTaskId()).setState(Protos.TaskState.TASK_RUNNING).build());
            Map data = (Map)SerializationUtils.deserialize((byte[])this.taskInfo.getData().toByteArray());
            ShardingContexts shardingContexts = (ShardingContexts)data.get("shardingContext");
            JobConfiguration jobConfig = ((JobConfigurationPOJO)YamlEngine.unmarshal((String)data.get("jobConfigContext").toString(), JobConfigurationPOJO.class)).toJobConfiguration();
            try {
                CloudJobFacade jobFacade = new CloudJobFacade(shardingContexts, jobConfig, TaskExecutor.this.jobTracingEventBus);
                if (this.isTransient(jobConfig)) {
                    this.getJobExecutor(jobFacade).execute();
                    this.executorDriver.sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(this.taskInfo.getTaskId()).setState(Protos.TaskState.TASK_FINISHED).build());
                } else {
                    new DaemonTaskScheduler(TaskExecutor.this.elasticJob, TaskExecutor.this.elasticJobType, jobConfig, jobFacade, this.executorDriver, this.taskInfo.getTaskId()).init();
                }
            }
            catch (Throwable ex) {
                log.error("ElasticJob-Cloud Executor error:", ex);
                this.executorDriver.sendStatusUpdate(Protos.TaskStatus.newBuilder().setTaskId(this.taskInfo.getTaskId()).setState(Protos.TaskState.TASK_ERROR).setMessage(ExceptionUtils.transform((Throwable)ex)).build());
                this.executorDriver.stop();
                throw ex;
            }
        }

        private boolean isTransient(JobConfiguration jobConfig) {
            return Strings.isNullOrEmpty((String)jobConfig.getCron());
        }

        private ElasticJobExecutor getJobExecutor(JobFacade jobFacade) {
            if (null == TaskExecutor.this.jobExecutor) {
                this.createJobExecutor(jobFacade);
            }
            return TaskExecutor.this.jobExecutor;
        }

        private synchronized void createJobExecutor(JobFacade jobFacade) {
            if (null != TaskExecutor.this.jobExecutor) {
                return;
            }
            TaskExecutor.this.jobExecutor = null == TaskExecutor.this.elasticJob ? new ElasticJobExecutor(TaskExecutor.this.elasticJobType, jobFacade.loadJobConfiguration(true), jobFacade) : new ElasticJobExecutor(TaskExecutor.this.elasticJob, jobFacade.loadJobConfiguration(true), jobFacade);
        }

        @Generated
        public TaskThread(ExecutorDriver executorDriver, Protos.TaskInfo taskInfo) {
            this.executorDriver = executorDriver;
            this.taskInfo = taskInfo;
        }
    }
}

