/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.SchemaAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;

public final class DeleteStatementContext
extends CommonSQLStatementContext<DeleteStatement>
implements TableAvailable,
WhereAvailable,
SchemaAvailable {
    private final TablesContext tablesContext = new TablesContext(this.getAllSimpleTableSegments());
    private final String schemaName;

    public DeleteStatementContext(DeleteStatement sqlStatement, String schemaName) {
        super(sqlStatement);
        this.schemaName = schemaName;
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromDelete((DeleteStatement)this.getSqlStatement());
        return this.filterAliasDeleteTable(tableExtractor.getRewriteTables());
    }

    private Collection<SimpleTableSegment> filterAliasDeleteTable(Collection<SimpleTableSegment> tableSegments) {
        Map aliasTableSegmentMap = tableSegments.stream().filter(each -> each.getAlias().isPresent()).collect(Collectors.toMap(each -> (String)each.getAlias().get(), Function.identity(), (oldValue, currentValue) -> oldValue));
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (SimpleTableSegment each2 : tableSegments) {
            SimpleTableSegment aliasDeleteTable = (SimpleTableSegment)aliasTableSegmentMap.get(each2.getTableName().getIdentifier().getValue());
            if (null != aliasDeleteTable && !aliasDeleteTable.equals(each2)) continue;
            result.add(each2);
        }
        return result;
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getOriginalTables();
    }

    @Override
    public Optional<WhereSegment> getWhere() {
        return ((DeleteStatement)this.getSqlStatement()).getWhere();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }
}

