/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.pagination.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.LimitPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.RowNumberPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.TopPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.OracleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.SQLServerStatement;

public final class PaginationContextEngine {
    public PaginationContext createPaginationContext(SelectStatement selectStatement, ProjectionsContext projectionsContext, List<Object> parameters) {
        Optional limitSegment = SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement);
        if (limitSegment.isPresent()) {
            return new LimitPaginationContextEngine().createPaginationContext((LimitSegment)limitSegment.get(), parameters);
        }
        Optional<TopProjectionSegment> topProjectionSegment = this.findTopProjection(selectStatement);
        Collection expressions = this.getWhereSegments(selectStatement).stream().map(WhereSegment::getExpr).collect(Collectors.toList());
        if (topProjectionSegment.isPresent()) {
            return new TopPaginationContextEngine().createPaginationContext(topProjectionSegment.get(), expressions, parameters);
        }
        if (!expressions.isEmpty() && this.containsRowNumberPagination(selectStatement)) {
            return new RowNumberPaginationContextEngine().createPaginationContext(expressions, projectionsContext, parameters);
        }
        return new PaginationContext(null, null, parameters);
    }

    private Collection<WhereSegment> getWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        selectStatement.getWhere().ifPresent(result::add);
        result.addAll(WhereExtractUtil.getSubqueryWhereSegments((SelectStatement)selectStatement));
        result.addAll(WhereExtractUtil.getJoinWhereSegments((SelectStatement)selectStatement));
        return result;
    }

    private boolean containsRowNumberPagination(SelectStatement selectStatement) {
        return selectStatement instanceof OracleStatement || selectStatement instanceof SQLServerStatement;
    }

    private Optional<TopProjectionSegment> findTopProjection(SelectStatement selectStatement) {
        List subqueryTableSegments = SQLUtil.getSubqueryTableSegmentFromTableSegment((TableSegment)selectStatement.getFrom());
        for (SubqueryTableSegment subquery : subqueryTableSegments) {
            SelectStatement subquerySelect = subquery.getSubquery().getSelect();
            for (ProjectionSegment each : subquerySelect.getProjections().getProjections()) {
                if (!(each instanceof TopProjectionSegment)) continue;
                return Optional.of((TopProjectionSegment)each);
            }
        }
        return Optional.empty();
    }
}

