/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.orderby.engine;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;

public final class OrderByContextEngine {
    public OrderByContext createOrderBy(ShardingSphereSchema schema, SelectStatement selectStatement, GroupByContext groupByContext) {
        if (!selectStatement.getOrderBy().isPresent() || ((OrderBySegment)selectStatement.getOrderBy().get()).getOrderByItems().isEmpty()) {
            if (groupByContext.getItems().isEmpty() && selectStatement.getProjections().isDistinctRow()) {
                OrderByContext result = this.createOrderByContextForDistinctRowWithoutGroupBy(selectStatement, groupByContext);
                return null != result ? result : this.getDefaultOrderByContextWithoutOrderBy(groupByContext);
            }
            if (selectStatement instanceof MySQLSelectStatement) {
                Optional<OrderByContext> result = this.createOrderByContextForMySQLSelectWithoutOrderBy(schema, selectStatement, groupByContext);
                return result.orElseGet(() -> this.getDefaultOrderByContextWithoutOrderBy(groupByContext));
            }
            return this.getDefaultOrderByContextWithoutOrderBy(groupByContext);
        }
        LinkedList<OrderByItem> orderByItems = new LinkedList<OrderByItem>();
        for (OrderByItemSegment each : ((OrderBySegment)selectStatement.getOrderBy().get()).getOrderByItems()) {
            OrderByItem orderByItem = new OrderByItem(each);
            if (each instanceof IndexOrderByItemSegment) {
                orderByItem.setIndex(((IndexOrderByItemSegment)each).getColumnIndex());
            }
            orderByItems.add(orderByItem);
        }
        return new OrderByContext(orderByItems, false);
    }

    private OrderByContext getDefaultOrderByContextWithoutOrderBy(GroupByContext groupByContext) {
        return new OrderByContext(groupByContext.getItems(), !groupByContext.getItems().isEmpty());
    }

    private OrderByContext createOrderByContextForDistinctRowWithoutGroupBy(SelectStatement selectStatement, GroupByContext groupByContext) {
        if (groupByContext.getItems().isEmpty() && selectStatement.getProjections().isDistinctRow()) {
            int index = 0;
            LinkedList<OrderByItem> orderByItems = new LinkedList<OrderByItem>();
            for (ProjectionSegment projectionSegment : selectStatement.getProjections().getProjections()) {
                if (!(projectionSegment instanceof ColumnProjectionSegment)) continue;
                ColumnProjectionSegment columnProjectionSegment = (ColumnProjectionSegment)projectionSegment;
                ColumnOrderByItemSegment columnOrderByItemSegment = new ColumnOrderByItemSegment(columnProjectionSegment.getColumn(), OrderDirection.ASC);
                OrderByItem item = new OrderByItem((OrderByItemSegment)columnOrderByItemSegment);
                item.setIndex(index++);
                orderByItems.add(item);
            }
            if (!orderByItems.isEmpty()) {
                return new OrderByContext(orderByItems, true);
            }
        }
        return null;
    }

    private Optional<OrderByContext> createOrderByContextForMySQLSelectWithoutOrderBy(ShardingSphereSchema schema, SelectStatement selectStatement, GroupByContext groupByContext) {
        if (!this.isNeedProcessMySQLSelectWithoutOrderBy(selectStatement, groupByContext)) {
            return Optional.empty();
        }
        int index = 0;
        LinkedList<OrderByItem> orderByItems = new LinkedList<OrderByItem>();
        TableMetaData tableMetaData = schema.get(((SimpleTableSegment)selectStatement.getFrom()).getTableName().getIdentifier().getValue());
        if (null == tableMetaData) {
            return Optional.empty();
        }
        for (String each : tableMetaData.getPrimaryKeyColumns()) {
            ColumnSegment columnSegment = new ColumnSegment(0, 0, new IdentifierValue(each, QuoteCharacter.NONE));
            OrderByItem item = new OrderByItem((OrderByItemSegment)new ColumnOrderByItemSegment(columnSegment, OrderDirection.ASC));
            item.setIndex(index++);
            orderByItems.add(item);
        }
        return orderByItems.isEmpty() ? Optional.empty() : Optional.of(new OrderByContext(orderByItems, true));
    }

    private boolean isNeedProcessMySQLSelectWithoutOrderBy(SelectStatement selectStatement, GroupByContext groupByContext) {
        if (!groupByContext.getItems().isEmpty()) {
            return false;
        }
        TableSegment tableSegment = selectStatement.getFrom();
        if (null == tableSegment) {
            return false;
        }
        if (!(tableSegment instanceof SimpleTableSegment)) {
            return false;
        }
        return selectStatement.getProjections().getProjections().stream().noneMatch(each -> each instanceof AggregationProjectionSegment);
    }
}

