/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingListStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowScalingListQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        this.data = ScalingAPIFactory.getScalingAPI().list().stream().map(each -> {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(each.getJobId());
            list.add(each.getTables());
            list.add(each.getShardingTotalCount());
            list.add(each.isActive() ? 1 : 0);
            list.add(each.getCreateTime());
            list.add(each.getStopTime());
            return list;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("id", "tables", "sharding_total_count", "active", "create_time", "stop_time");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowScalingListStatement.class.getCanonicalName();
    }
}

