/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingCheckAlgorithmsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShowScalingCheckAlgorithmsQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        this.data = ScalingAPIFactory.getScalingAPI().listDataConsistencyCheckAlgorithms().stream().map(each -> {
            LinkedList<String> list = new LinkedList<String>();
            list.add(each.getType());
            list.add(each.getDescription());
            list.add(Joiner.on((String)",").join((Iterable)each.getSupportedDatabaseTypes()));
            list.add(each.getProvider());
            return list;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "description", "supported_database_types", "provider");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return ShowScalingCheckAlgorithmsStatement.class.getCanonicalName();
    }
}

