/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.core.api.ScalingAPIFactory;
import org.apache.shardingsphere.scaling.core.job.check.consistency.DataConsistencyCheckResult;
import org.apache.shardingsphere.scaling.distsql.statement.CheckScalingStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class CheckScalingQueryResultSet
implements DistSQLResultSet {
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        CheckScalingStatement checkScalingStatement = (CheckScalingStatement)sqlStatement;
        Map checkResultMap = null == checkScalingStatement.getTypeStrategy() ? ScalingAPIFactory.getScalingAPI().dataConsistencyCheck(checkScalingStatement.getJobId()) : ScalingAPIFactory.getScalingAPI().dataConsistencyCheck(checkScalingStatement.getJobId(), checkScalingStatement.getTypeStrategy().getName());
        this.data = checkResultMap.entrySet().stream().map(each -> {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(each.getKey());
            list.add(((DataConsistencyCheckResult)each.getValue()).getSourceCount());
            list.add(((DataConsistencyCheckResult)each.getValue()).getTargetCount());
            list.add(((DataConsistencyCheckResult)each.getValue()).isCountValid() + "");
            list.add(((DataConsistencyCheckResult)each.getValue()).isDataValid() + "");
            return list;
        }).collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table_name", "source_count", "target_count", "count_valid", "data_valid");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return CheckScalingStatement.class.getCanonicalName();
    }
}

