/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.note.NoteShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

public final class ShadowTableRule {
    private final String tableName;
    private final Collection<String> shadowDataSources;
    private final Collection<String> noteShadowAlgorithmNames;
    private final Map<ShadowOperationType, Collection<String>> columnShadowAlgorithmNames;

    public ShadowTableRule(String tableName, Collection<String> shadowDataSources, Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        this.tableName = tableName;
        this.shadowDataSources = shadowDataSources;
        this.noteShadowAlgorithmNames = this.initNoteShadowAlgorithmNames(shadowAlgorithmNames, shadowAlgorithms);
        this.columnShadowAlgorithmNames = this.initColumnShadowAlgorithmNames(shadowAlgorithmNames, shadowAlgorithms);
    }

    private Collection<String> initNoteShadowAlgorithmNames(Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        return shadowAlgorithmNames.stream().filter(each -> shadowAlgorithms.get(each) instanceof NoteShadowAlgorithm).collect(Collectors.toCollection(LinkedList::new));
    }

    private Map<ShadowOperationType, Collection<String>> initColumnShadowAlgorithmNames(Collection<String> shadowAlgorithmNames, Map<String, ShadowAlgorithm> shadowAlgorithms) {
        EnumMap<ShadowOperationType, Collection<String>> result = new EnumMap<ShadowOperationType, Collection<String>>(ShadowOperationType.class);
        shadowAlgorithmNames.forEach(each -> {
            ShadowAlgorithm shadowAlgorithm = (ShadowAlgorithm)shadowAlgorithms.get(each);
            if (shadowAlgorithm instanceof ColumnShadowAlgorithm) {
                ShadowOperationType.contains((String)shadowAlgorithm.getProps().get("operation").toString()).ifPresent(shadowOperationType -> this.initShadowAlgorithmNames((Map<ShadowOperationType, Collection<String>>)result, (String)each, (ShadowOperationType)shadowOperationType));
            }
        });
        return result;
    }

    private void initShadowAlgorithmNames(Map<ShadowOperationType, Collection<String>> columnShadowAlgorithmNames, String algorithmName, ShadowOperationType operationType) {
        Collection<String> names = columnShadowAlgorithmNames.get(operationType);
        Preconditions.checkState((null == names ? 1 : 0) != 0, (String)"Column shadow algorithm `%s` operation only supports one column mapping in shadow table `%s`.", (Object)operationType.name(), (Object)this.tableName);
        columnShadowAlgorithmNames.put(operationType, Collections.singletonList(algorithmName));
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Collection<String> getShadowDataSources() {
        return this.shadowDataSources;
    }

    @Generated
    public Collection<String> getNoteShadowAlgorithmNames() {
        return this.noteShadowAlgorithmNames;
    }

    @Generated
    public Map<ShadowOperationType, Collection<String>> getColumnShadowAlgorithmNames() {
        return this.columnShadowAlgorithmNames;
    }
}

