/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;

public final class ShadowExtractor {
    public static Optional<ColumnSegment> extractColumn(ExpressionSegment expressionSegment) {
        Collection columnSegments = ColumnExtractor.extract((ExpressionSegment)expressionSegment);
        return 1 == columnSegments.size() ? Optional.of(columnSegments.iterator().next()) : Optional.empty();
    }

    public static Optional<Collection<Comparable<?>>> extractValues(ExpressionSegment expression, List<Object> parameters) {
        LinkedList result = new LinkedList();
        if (expression instanceof BinaryOperationExpression) {
            ShadowExtractor.extractValues(((BinaryOperationExpression)expression).getRight(), parameters).ifPresent(result::addAll);
        }
        if (expression instanceof InExpression) {
            ShadowExtractor.extractValues(((InExpression)expression).getRight(), parameters).ifPresent(result::addAll);
        }
        if (expression instanceof ListExpression) {
            ((ListExpression)expression).getItems().forEach(each -> ShadowExtractor.extractValueInSimpleExpressionSegment(each, parameters).ifPresent(result::add));
        }
        if (expression instanceof SimpleExpressionSegment) {
            ShadowExtractor.extractValueInSimpleExpressionSegment(expression, parameters).ifPresent(result::add);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private static Optional<Comparable<?>> extractValueInSimpleExpressionSegment(ExpressionSegment expression, List<Object> parameters) {
        if (expression instanceof LiteralExpressionSegment) {
            return ShadowExtractor.extractValueInLiteralExpressionSegment((LiteralExpressionSegment)expression);
        }
        if (expression instanceof ParameterMarkerExpressionSegment) {
            return ShadowExtractor.extractValueInParameterMarkerExpressionSegment((ParameterMarkerExpressionSegment)expression, parameters);
        }
        return Optional.empty();
    }

    private static Optional<Comparable<?>> extractValueInParameterMarkerExpressionSegment(ParameterMarkerExpressionSegment expression, List<Object> parameters) {
        return ShadowExtractor.castToComparable(parameters.get(expression.getParameterMarkerIndex()));
    }

    private static Optional<Comparable<?>> extractValueInLiteralExpressionSegment(LiteralExpressionSegment expression) {
        return ShadowExtractor.castToComparable(expression.getLiterals());
    }

    private static Optional<Comparable<?>> castToComparable(Object object) {
        return object instanceof Comparable ? Optional.of((Comparable)object) : Optional.empty();
    }

    @Generated
    private ShadowExtractor() {
    }
}

