/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.note.NoteShadowAlgorithm;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.ShadowDeterminerFactory;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;

public final class ShadowNonDMLStatementRoutingEngine
implements ShadowRouteEngine {
    private final SQLStatementContext<?> sqlStatementContext;

    @Override
    public void route(RouteContext routeContext, ShadowRule shadowRule) {
        this.findShadowDataSourceMappings(shadowRule).ifPresent(stringStringMap -> this.shadowRouteDecorate(routeContext, (Map<String, String>)stringStringMap));
    }

    private Optional<Map<String, String>> findShadowDataSourceMappings(ShadowRule shadowRule) {
        Optional<Collection<String>> sqlNotes = this.parseSqlNotes();
        if (!sqlNotes.isPresent()) {
            return Optional.empty();
        }
        Optional<Collection<NoteShadowAlgorithm<Comparable<?>>>> noteShadowAlgorithms = shadowRule.getAllNoteShadowAlgorithms();
        if (!noteShadowAlgorithms.isPresent()) {
            return Optional.empty();
        }
        if (this.isMatchAnyNoteShadowAlgorithms(noteShadowAlgorithms.get(), this.createShadowDetermineCondition(sqlNotes.get()), shadowRule)) {
            return Optional.of(shadowRule.getAllShadowDataSourceMappings());
        }
        return Optional.empty();
    }

    private Optional<Collection<String>> parseSqlNotes() {
        Collection result = ((AbstractSQLStatement)this.sqlStatementContext.getSqlStatement()).getCommentSegments().stream().map(CommentSegment::getText).collect(Collectors.toCollection(LinkedList::new));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private ShadowDetermineCondition createShadowDetermineCondition(Collection<String> sqlNotes) {
        ShadowDetermineCondition result = new ShadowDetermineCondition("", ShadowOperationType.NOTE_MATCH);
        return result.initSqlNotes(sqlNotes);
    }

    private boolean isMatchAnyNoteShadowAlgorithms(Collection<NoteShadowAlgorithm<Comparable<?>>> shadowAlgorithms, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        for (NoteShadowAlgorithm<Comparable<?>> each : shadowAlgorithms) {
            if (!this.isMatchNoteShadowAlgorithm(each, shadowCondition, shadowRule)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchNoteShadowAlgorithm(NoteShadowAlgorithm<Comparable<?>> noteShadowAlgorithm, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        return ShadowDeterminerFactory.newInstance(noteShadowAlgorithm).isShadow(shadowCondition, shadowRule);
    }

    @Generated
    public ShadowNonDMLStatementRoutingEngine(SQLStatementContext<?> sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

