/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.determiner.algorithm;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.note.NoteShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.note.PreciseNoteShadowValue;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.determiner.ShadowAlgorithmDeterminer;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class NoteShadowAlgorithmDeterminer
implements ShadowAlgorithmDeterminer {
    private final NoteShadowAlgorithm<Comparable<?>> noteShadowAlgorithm;

    @Override
    public boolean isShadow(ShadowDetermineCondition shadowDetermineCondition, ShadowRule shadowRule) {
        Collection<PreciseNoteShadowValue<Comparable<?>>> noteShadowValues = this.createNoteShadowValues(shadowDetermineCondition);
        for (PreciseNoteShadowValue<Comparable<?>> each : noteShadowValues) {
            if (!this.noteShadowAlgorithm.isShadow(shadowRule.getAllShadowTableNames(), each)) continue;
            return true;
        }
        return false;
    }

    private Collection<PreciseNoteShadowValue<Comparable<?>>> createNoteShadowValues(ShadowDetermineCondition shadowDetermineCondition) {
        ShadowOperationType shadowOperationType = shadowDetermineCondition.getShadowOperationType();
        String tableName = shadowDetermineCondition.getTableName();
        return shadowDetermineCondition.getSqlNotes().stream().map(each -> new PreciseNoteShadowValue(tableName, shadowOperationType, (Comparable)((Object)each))).collect(Collectors.toCollection(LinkedList::new));
    }

    @Generated
    public NoteShadowAlgorithmDeterminer(NoteShadowAlgorithm<Comparable<?>> noteShadowAlgorithm) {
        this.noteShadowAlgorithm = noteShadowAlgorithm;
    }
}

