/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.err;

import com.google.common.base.Strings;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLErrorCode;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLMessageSeverityLevel;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLErrorResponsePacket;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.InvalidAuthorizationSpecificationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLAuthenticationException;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.exception.PostgreSQLProtocolViolationException;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;

public final class PostgreSQLErrPacketFactory {
    public static PostgreSQLErrorResponsePacket newInstance(Exception cause) {
        if (cause instanceof PSQLException && null != ((PSQLException)cause).getServerErrorMessage()) {
            return PostgreSQLErrPacketFactory.createErrorResponsePacket(((PSQLException)cause).getServerErrorMessage());
        }
        if (cause instanceof SQLException) {
            return PostgreSQLErrPacketFactory.createErrorResponsePacket((SQLException)cause);
        }
        if (cause instanceof InvalidAuthorizationSpecificationException) {
            return PostgreSQLErrorResponsePacket.newBuilder((PostgreSQLMessageSeverityLevel)PostgreSQLMessageSeverityLevel.FATAL, (PostgreSQLErrorCode)PostgreSQLErrorCode.INVALID_AUTHORIZATION_SPECIFICATION, (String)cause.getMessage()).build();
        }
        if (cause instanceof PostgreSQLProtocolViolationException) {
            return PostgreSQLErrorResponsePacket.newBuilder((PostgreSQLMessageSeverityLevel)PostgreSQLMessageSeverityLevel.FATAL, (PostgreSQLErrorCode)PostgreSQLErrorCode.PROTOCOL_VIOLATION, (String)String.format("expected %s response, got message type %s", ((PostgreSQLProtocolViolationException)((Object)cause)).getExpectedMessageType(), ((PostgreSQLProtocolViolationException)((Object)cause)).getActualMessageType())).build();
        }
        if (cause instanceof PostgreSQLAuthenticationException) {
            return PostgreSQLErrorResponsePacket.newBuilder((PostgreSQLMessageSeverityLevel)PostgreSQLMessageSeverityLevel.FATAL, (PostgreSQLErrorCode)((PostgreSQLAuthenticationException)((Object)cause)).getErrorCode(), (String)cause.getMessage()).build();
        }
        return PostgreSQLErrPacketFactory.createErrorResponsePacketForUnknownException(cause);
    }

    private static PostgreSQLErrorResponsePacket createErrorResponsePacket(SQLException cause) {
        String sqlState = Strings.isNullOrEmpty((String)cause.getSQLState()) ? PostgreSQLErrorCode.SYSTEM_ERROR.getErrorCode() : cause.getSQLState();
        String message = Strings.isNullOrEmpty((String)cause.getMessage()) ? cause.toString() : cause.getMessage();
        return PostgreSQLErrorResponsePacket.newBuilder((PostgreSQLMessageSeverityLevel)PostgreSQLMessageSeverityLevel.ERROR, (String)sqlState, (String)message).build();
    }

    private static PostgreSQLErrorResponsePacket createErrorResponsePacket(ServerErrorMessage serverErrorMessage) {
        return PostgreSQLErrorResponsePacket.newBuilder((PostgreSQLMessageSeverityLevel)PostgreSQLMessageSeverityLevel.valueOf((String)serverErrorMessage.getSeverity()), (String)serverErrorMessage.getSQLState(), (String)serverErrorMessage.getMessage()).detail(serverErrorMessage.getDetail()).hint(serverErrorMessage.getHint()).position(serverErrorMessage.getPosition()).internalQueryAndInternalPosition(serverErrorMessage.getInternalQuery(), serverErrorMessage.getInternalPosition()).where(serverErrorMessage.getWhere()).schemaName(serverErrorMessage.getSchema()).tableName(serverErrorMessage.getTable()).columnName(serverErrorMessage.getColumn()).dataTypeName(serverErrorMessage.getDatatype()).constraintName(serverErrorMessage.getConstraint()).file(serverErrorMessage.getFile()).line(serverErrorMessage.getLine()).routine(serverErrorMessage.getRoutine()).build();
    }

    private static PostgreSQLErrorResponsePacket createErrorResponsePacketForUnknownException(Exception cause) {
        String message = Strings.isNullOrEmpty((String)cause.getLocalizedMessage()) ? cause.toString() : cause.getLocalizedMessage();
        return PostgreSQLErrorResponsePacket.newBuilder((PostgreSQLMessageSeverityLevel)PostgreSQLMessageSeverityLevel.ERROR, (PostgreSQLErrorCode)PostgreSQLErrorCode.SYSTEM_ERROR, (String)message).build();
    }

    @Generated
    private PostgreSQLErrPacketFactory() {
    }
}

