/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.sync;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;

public final class PostgreSQLComSyncExecutor
implements QueryCommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final BackendConnection backendConnection;

    public Collection<DatabasePacket<?>> execute() {
        this.connectionContext.clearContext();
        return Collections.singleton(new PostgreSQLReadyForQueryPacket(this.backendConnection.getTransactionStatus().isInTransaction()));
    }

    public ResponseType getResponseType() {
        return ResponseType.UPDATE;
    }

    public boolean next() throws SQLException {
        return false;
    }

    public DatabasePacket<?> getQueryRowPacket() {
        throw new UnsupportedOperationException("PostgreSQLComSyncExecutor returns no query row packet.");
    }

    @Generated
    public PostgreSQLComSyncExecutor(PostgreSQLConnectionContext connectionContext, BackendConnection backendConnection) {
        this.connectionContext = connectionContext;
        this.backendConnection = backendConnection;
    }
}

