/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.execute;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLEmptyQueryResponsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.execute.PostgreSQLPortalSuspendedPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.PostgreSQLPortal;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackStatement;

public final class PostgreSQLComExecuteExecutor
implements CommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final PostgreSQLComExecutePacket packet;
    private long dataRows;

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        LinkedList result = new LinkedList();
        for (CommandExecutor each : this.connectionContext.getPendingExecutors()) {
            result.addAll(each.execute());
        }
        this.connectionContext.getPendingExecutors().clear();
        result.addAll(this.doExecute());
        result.add((DatabasePacket<?>)this.createExecutionCompletedPacket());
        return result;
    }

    private Collection<? extends DatabasePacket<?>> doExecute() throws SQLException {
        Optional<DatabasePacket<?>> packet;
        LinkedList result = new LinkedList();
        while (!this.isPortalSuspended() && (packet = this.getPacketFromPortal()).isPresent()) {
            ++this.dataRows;
            result.add(packet.get());
        }
        return result;
    }

    private Optional<DatabasePacket<?>> getPacketFromPortal() throws SQLException {
        PostgreSQLPortal portal = this.connectionContext.getPortal(this.packet.getPortal());
        return portal.next() ? Optional.of(portal.nextPacket()) : Optional.empty();
    }

    private PostgreSQLIdentifierPacket createExecutionCompletedPacket() {
        if (this.isPortalSuspended()) {
            return new PostgreSQLPortalSuspendedPacket();
        }
        PostgreSQLPortal portal = this.connectionContext.getPortal(this.packet.getPortal());
        if (portal.getSqlStatement() instanceof EmptyStatement) {
            return new PostgreSQLEmptyQueryResponsePacket();
        }
        String sqlCommand = PostgreSQLCommand.valueOf(portal.getSqlStatement().getClass()).map(PostgreSQLCommand::getTag).orElse("");
        return new PostgreSQLCommandCompletePacket(sqlCommand, Math.max(this.dataRows, portal.getUpdateCount()));
    }

    public void close() throws SQLException {
        PostgreSQLPortal portal = this.connectionContext.getPortal(this.packet.getPortal());
        if (this.isPortalSuspended()) {
            portal.suspend();
            return;
        }
        if (portal.getSqlStatement() instanceof CommitStatement || portal.getSqlStatement() instanceof RollbackStatement) {
            this.connectionContext.closeAllPortals();
        } else {
            this.connectionContext.closePortal(this.packet.getPortal());
        }
    }

    private boolean isPortalSuspended() {
        return this.packet.getMaxRows() > 0 && this.dataRows == (long)this.packet.getMaxRows();
    }

    @Generated
    public PostgreSQLComExecuteExecutor(PostgreSQLConnectionContext connectionContext, PostgreSQLComExecutePacket packet) {
        this.connectionContext = connectionContext;
        this.packet = packet;
    }
}

