/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.close;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.close.PostgreSQLCloseCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;

public final class PostgreSQLComCloseExecutor
implements CommandExecutor {
    private final PostgreSQLConnectionContext connectionContext;
    private final PostgreSQLComClosePacket packet;
    private final BackendConnection backendConnection;

    public Collection<DatabasePacket<?>> execute() throws SQLException {
        switch (this.packet.getType()) {
            case PREPARED_STATEMENT: {
                PostgreSQLBinaryStatementRegistry.getInstance().unregister(this.backendConnection.getConnectionId(), this.packet.getName());
                break;
            }
            case PORTAL: {
                this.closePortal();
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.packet.getType().name());
            }
        }
        return Collections.singletonList(new PostgreSQLCloseCompletePacket());
    }

    private void closePortal() throws SQLException {
        this.connectionContext.closePortal(this.packet.getName());
    }

    @Generated
    public PostgreSQLComCloseExecutor(PostgreSQLConnectionContext connectionContext, PostgreSQLComClosePacket packet, BackendConnection backendConnection) {
        this.connectionContext = connectionContext;
        this.packet = packet;
        this.backendConnection = backendConnection;
    }
}

