/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLNoDataPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.text.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.BinaryQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.impl.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandlerFactory;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;

public final class PostgreSQLPortal {
    private final SQLStatement sqlStatement;
    private final List<PostgreSQLValueFormat> resultFormats;
    private final DatabaseCommunicationEngine databaseCommunicationEngine;
    private final TextProtocolBackendHandler textProtocolBackendHandler;
    private final BackendConnection backendConnection;
    private ResponseHeader responseHeader;

    public PostgreSQLPortal(PostgreSQLBinaryStatement binaryStatement, List<Object> parameters, List<PostgreSQLValueFormat> resultFormats, BackendConnection backendConnection) throws SQLException {
        this.sqlStatement = binaryStatement.getSqlStatement();
        this.resultFormats = resultFormats;
        this.backendConnection = backendConnection;
        if (this.sqlStatement instanceof TCLStatement || this.sqlStatement instanceof EmptyStatement || this.sqlStatement instanceof DistSQLStatement) {
            this.databaseCommunicationEngine = null;
            this.textProtocolBackendHandler = TextProtocolBackendHandlerFactory.newInstance((DatabaseType)DatabaseTypeRegistry.getActualDatabaseType((String)"PostgreSQL"), (String)binaryStatement.getSql(), (BackendConnection)backendConnection);
            return;
        }
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaDataMap(), parameters, (SQLStatement)this.sqlStatement, (String)backendConnection.getDefaultSchemaName());
        this.databaseCommunicationEngine = DatabaseCommunicationEngineFactory.getInstance().newBinaryProtocolInstance(sqlStatementContext, binaryStatement.getSql(), parameters, backendConnection);
        this.textProtocolBackendHandler = null;
    }

    public void execute() throws SQLException {
        this.responseHeader = null != this.databaseCommunicationEngine ? this.databaseCommunicationEngine.execute() : this.textProtocolBackendHandler.execute();
    }

    public PostgreSQLPacket describe() {
        if (this.responseHeader instanceof QueryResponseHeader) {
            return this.createRowDescriptionPacket((QueryResponseHeader)this.responseHeader);
        }
        if (this.responseHeader instanceof UpdateResponseHeader) {
            return new PostgreSQLNoDataPacket();
        }
        throw new UnsupportedOperationException("Failed to describe portal");
    }

    private PostgreSQLRowDescriptionPacket createRowDescriptionPacket(QueryResponseHeader queryResponseHeader) {
        Collection<PostgreSQLColumnDescription> columnDescriptions = this.createColumnDescriptions(queryResponseHeader);
        return new PostgreSQLRowDescriptionPacket(columnDescriptions.size(), columnDescriptions);
    }

    private Collection<PostgreSQLColumnDescription> createColumnDescriptions(QueryResponseHeader queryResponseHeader) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        int columnIndex = 0;
        for (QueryHeader each : queryResponseHeader.getQueryHeaders()) {
            result.add(new PostgreSQLColumnDescription(each.getColumnLabel(), ++columnIndex, each.getColumnType(), each.getColumnLength(), each.getColumnTypeName()));
        }
        return result;
    }

    public long getUpdateCount() {
        return this.responseHeader instanceof UpdateResponseHeader ? ((UpdateResponseHeader)this.responseHeader).getUpdateCount() : 0L;
    }

    public boolean next() throws SQLException {
        return null != this.databaseCommunicationEngine && this.databaseCommunicationEngine.next() || null != this.textProtocolBackendHandler && this.textProtocolBackendHandler.next();
    }

    public PostgreSQLPacket nextPacket() throws SQLException {
        return null != this.databaseCommunicationEngine ? new PostgreSQLDataRowPacket(this.getData(this.databaseCommunicationEngine.getQueryResponseRow())) : new PostgreSQLDataRowPacket(this.textProtocolBackendHandler.getRowData());
    }

    private List<Object> getData(QueryResponseRow queryResponseRow) {
        Collection cells = queryResponseRow.getCells();
        ArrayList<Object> result = new ArrayList<Object>(cells.size());
        ArrayList columns = new ArrayList(cells);
        for (int i = 0; i < columns.size(); ++i) {
            PostgreSQLValueFormat format = this.determineValueFormat(i);
            result.add(PostgreSQLValueFormat.BINARY == format ? this.createBinaryCell((QueryResponseCell)columns.get(i)) : ((QueryResponseCell)columns.get(i)).getData());
        }
        return result;
    }

    private PostgreSQLValueFormat determineValueFormat(int columnIndex) {
        return this.resultFormats.isEmpty() ? PostgreSQLValueFormat.TEXT : this.resultFormats.get(columnIndex % this.resultFormats.size());
    }

    private BinaryCell createBinaryCell(QueryResponseCell cell) {
        return new BinaryCell((BinaryColumnType)PostgreSQLBinaryColumnType.valueOfJDBCType((int)((BinaryQueryResponseCell)cell).getJdbcType()), cell.getData());
    }

    public void suspend() {
        this.backendConnection.markResourceInUse(this.databaseCommunicationEngine);
    }

    public void close() throws SQLException {
        if (null != this.databaseCommunicationEngine) {
            this.backendConnection.unmarkResourceInUse(this.databaseCommunicationEngine);
        }
        if (null != this.textProtocolBackendHandler) {
            this.textProtocolBackendHandler.close();
        }
    }

    @Generated
    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }
}

