/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;

public final class PostgreSQLConnectionContextRegistry {
    private static final PostgreSQLConnectionContextRegistry INSTANCE = new PostgreSQLConnectionContextRegistry();
    private final ConcurrentMap<Integer, PostgreSQLConnectionContext> connectionContexts = new ConcurrentHashMap<Integer, PostgreSQLConnectionContext>(1024);

    public static PostgreSQLConnectionContextRegistry getInstance() {
        return INSTANCE;
    }

    public PostgreSQLConnectionContext get(int connectionId) {
        return this.connectionContexts.computeIfAbsent(connectionId, unused -> new PostgreSQLConnectionContext());
    }

    public PostgreSQLConnectionContext remove(int connectionId) {
        return (PostgreSQLConnectionContext)this.connectionContexts.remove(connectionId);
    }

    @Generated
    private PostgreSQLConnectionContextRegistry() {
    }
}

