/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatement;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.PostgreSQLPortal;

public final class PostgreSQLConnectionContext {
    private final Map<String, PostgreSQLPortal> portals = new LinkedHashMap<String, PostgreSQLPortal>();
    private final Collection<CommandExecutor> pendingExecutors = new LinkedList<CommandExecutor>();
    private PostgreSQLCommandPacketType currentPacketType;
    private boolean errorOccurred;

    public PostgreSQLPortal createPortal(String portal, PostgreSQLBinaryStatement binaryStatement, List<Object> parameters, List<PostgreSQLValueFormat> resultFormats, BackendConnection backendConnection) throws SQLException {
        PostgreSQLPortal result = new PostgreSQLPortal(binaryStatement, parameters, resultFormats, backendConnection);
        this.portals.put(portal, result);
        return result;
    }

    public PostgreSQLPortal getPortal(String portal) {
        return this.portals.get(portal);
    }

    public void closePortal(String portal) throws SQLException {
        PostgreSQLPortal result = this.portals.remove(portal);
        if (null != result) {
            result.close();
        }
    }

    public void closeAllPortals() throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (PostgreSQLPortal each : this.portals.values()) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.portals.clear();
        if (result.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException("Close all portals failed.");
        result.forEach(ex::setNextException);
        throw ex;
    }

    public void clearContext() {
        this.pendingExecutors.clear();
        this.currentPacketType = null;
        this.errorOccurred = false;
    }

    @Generated
    public Collection<CommandExecutor> getPendingExecutors() {
        return this.pendingExecutors;
    }

    @Generated
    public PostgreSQLCommandPacketType getCurrentPacketType() {
        return this.currentPacketType;
    }

    @Generated
    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    @Generated
    public void setCurrentPacketType(PostgreSQLCommandPacketType currentPacketType) {
        this.currentPacketType = currentPacketType;
    }

    @Generated
    public void setErrorOccurred(boolean errorOccurred) {
        this.errorOccurred = errorOccurred;
    }
}

