/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import java.sql.SQLException;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.text.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.generic.PostgreSQLComTerminationExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.generic.PostgreSQLUnsupportedCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.bind.PostgreSQLComBindExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.close.PostgreSQLComCloseExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.describe.PostgreSQLComDescribeExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.execute.PostgreSQLComExecuteExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.parse.PostgreSQLComParseExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.sync.PostgreSQLComSyncExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.text.PostgreSQLComQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLCommandExecutorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLCommandExecutorFactory.class);

    public static CommandExecutor newInstance(PostgreSQLCommandPacketType commandPacketType, PostgreSQLCommandPacket commandPacket, BackendConnection backendConnection, PostgreSQLConnectionContext connectionContext) throws SQLException {
        log.debug("Execute packet type: {}, value: {}", (Object)commandPacketType, (Object)commandPacket);
        switch (commandPacketType) {
            case SIMPLE_QUERY: {
                return new PostgreSQLComQueryExecutor(connectionContext, (PostgreSQLComQueryPacket)commandPacket, backendConnection);
            }
            case PARSE_COMMAND: {
                return new PostgreSQLComParseExecutor((PostgreSQLComParsePacket)commandPacket, backendConnection);
            }
            case BIND_COMMAND: {
                connectionContext.getPendingExecutors().add(new PostgreSQLComBindExecutor(connectionContext, (PostgreSQLComBindPacket)commandPacket, backendConnection));
                break;
            }
            case DESCRIBE_COMMAND: {
                connectionContext.getPendingExecutors().add(new PostgreSQLComDescribeExecutor(connectionContext, (PostgreSQLComDescribePacket)commandPacket));
                break;
            }
            case EXECUTE_COMMAND: {
                return new PostgreSQLComExecuteExecutor(connectionContext, (PostgreSQLComExecutePacket)commandPacket);
            }
            case SYNC_COMMAND: {
                return new PostgreSQLComSyncExecutor(connectionContext, backendConnection);
            }
            case CLOSE_COMMAND: {
                connectionContext.getPendingExecutors().add(new PostgreSQLComCloseExecutor(connectionContext, (PostgreSQLComClosePacket)commandPacket, backendConnection));
                break;
            }
            case TERMINATE: {
                return new PostgreSQLComTerminationExecutor();
            }
            default: {
                return new PostgreSQLUnsupportedCommandExecutor(connectionContext);
            }
        }
        return Collections::emptyList;
    }

    @Generated
    private PostgreSQLCommandExecutorFactory() {
    }
}

