/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command;

import io.netty.channel.ChannelHandlerContext;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.db.protocol.packet.CommandPacket;
import org.apache.shardingsphere.db.protocol.packet.CommandPacketType;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketTypeLoader;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.text.PostgreSQLDataRowPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLCommandCompletePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLCommandExecutorFactory;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContextRegistry;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.PostgreSQLCommand;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.binary.sync.PostgreSQLComSyncExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.text.PostgreSQLComQueryExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.err.PostgreSQLErrPacketFactory;

public final class PostgreSQLCommandExecuteEngine
implements CommandExecuteEngine {
    public PostgreSQLCommandPacketType getCommandPacketType(PacketPayload payload) {
        return PostgreSQLCommandPacketTypeLoader.getCommandPacketType((PostgreSQLPacketPayload)((PostgreSQLPacketPayload)payload));
    }

    public PostgreSQLCommandPacket getCommandPacket(PacketPayload payload, CommandPacketType type, BackendConnection backendConnection) {
        PostgreSQLConnectionContext connectionContext = PostgreSQLConnectionContextRegistry.getInstance().get(backendConnection.getConnectionId());
        connectionContext.setCurrentPacketType((PostgreSQLCommandPacketType)type);
        return PostgreSQLCommandPacketFactory.newInstance((PostgreSQLCommandPacketType)((PostgreSQLCommandPacketType)type), (PostgreSQLPacketPayload)((PostgreSQLPacketPayload)payload), (int)backendConnection.getConnectionId());
    }

    public CommandExecutor getCommandExecutor(CommandPacketType type, CommandPacket packet, BackendConnection backendConnection) throws SQLException {
        PostgreSQLConnectionContext connectionContext = PostgreSQLConnectionContextRegistry.getInstance().get(backendConnection.getConnectionId());
        if (connectionContext.isErrorOccurred() && PostgreSQLCommandPacketType.isExtendedProtocolPacketType((PostgreSQLCommandPacketType)((PostgreSQLCommandPacketType)type)) && PostgreSQLCommandPacketType.SYNC_COMMAND != type) {
            return Collections::emptyList;
        }
        return PostgreSQLCommandExecutorFactory.newInstance((PostgreSQLCommandPacketType)type, (PostgreSQLCommandPacket)packet, backendConnection, connectionContext);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause, BackendConnection backendConnection) {
        PostgreSQLConnectionContext connectionContext = PostgreSQLConnectionContextRegistry.getInstance().get(backendConnection.getConnectionId());
        if (PostgreSQLCommandPacketType.isExtendedProtocolPacketType((PostgreSQLCommandPacketType)connectionContext.getCurrentPacketType())) {
            connectionContext.setErrorOccurred(true);
            connectionContext.getPendingExecutors().clear();
        }
        return PostgreSQLErrPacketFactory.newInstance(cause);
    }

    public DatabasePacket<?> getErrorPacket(Exception cause) {
        return PostgreSQLErrPacketFactory.newInstance(cause);
    }

    public Optional<DatabasePacket<?>> getOtherPacket(BackendConnection backendConnection) {
        PostgreSQLConnectionContext connectionContext = PostgreSQLConnectionContextRegistry.getInstance().get(backendConnection.getConnectionId());
        return PostgreSQLCommandPacketType.isExtendedProtocolPacketType((PostgreSQLCommandPacketType)connectionContext.getCurrentPacketType()) ? Optional.empty() : Optional.of(new PostgreSQLReadyForQueryPacket(backendConnection.getTransactionStatus().isInTransaction()));
    }

    public boolean writeQueryData(ChannelHandlerContext context, BackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor, int headerPackagesCount) throws SQLException {
        if (queryCommandExecutor instanceof PostgreSQLComSyncExecutor) {
            return true;
        }
        if (ResponseType.QUERY == queryCommandExecutor.getResponseType() && !context.channel().isActive()) {
            context.write((Object)new PostgreSQLCommandCompletePacket(PostgreSQLCommand.SELECT.name(), 0L));
            return true;
        }
        if (queryCommandExecutor instanceof PostgreSQLComQueryExecutor) {
            return this.processSimpleQuery(context, backendConnection, (PostgreSQLComQueryExecutor)queryCommandExecutor);
        }
        this.writeDataPackets(context, backendConnection, queryCommandExecutor);
        return false;
    }

    private boolean processSimpleQuery(ChannelHandlerContext context, BackendConnection backendConnection, PostgreSQLComQueryExecutor queryExecutor) throws SQLException {
        if (ResponseType.UPDATE == queryExecutor.getResponseType()) {
            context.write((Object)new PostgreSQLReadyForQueryPacket(backendConnection.getTransactionStatus().isInTransaction()));
            return true;
        }
        long dataRows = this.writeDataPackets(context, backendConnection, queryExecutor);
        if (ResponseType.QUERY == queryExecutor.getResponseType()) {
            context.write((Object)new PostgreSQLCommandCompletePacket(PostgreSQLCommand.SELECT.name(), dataRows));
        }
        context.write((Object)new PostgreSQLReadyForQueryPacket(backendConnection.getTransactionStatus().isInTransaction()));
        return true;
    }

    private long writeDataPackets(ChannelHandlerContext context, BackendConnection backendConnection, QueryCommandExecutor queryCommandExecutor) throws SQLException {
        long dataRows = 0L;
        int flushCount = 0;
        int proxyFrontendFlushThreshold = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_FLUSH_THRESHOLD);
        while (queryCommandExecutor.next()) {
            ++flushCount;
            while (!context.channel().isWritable() && context.channel().isActive()) {
                context.flush();
                backendConnection.getResourceLock().doAwait();
            }
            DatabasePacket resultValue = queryCommandExecutor.getQueryRowPacket();
            context.write((Object)resultValue);
            if (proxyFrontendFlushThreshold == flushCount) {
                context.flush();
                flushCount = 0;
            }
            if (!(resultValue instanceof PostgreSQLDataRowPacket)) continue;
            ++dataRows;
        }
        return dataRows;
    }
}

